/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.util.Range;

public class UnaryExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel expression;
    private final Operator operator;

    public UnaryExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel expression, @Nonnull Operator operator) {
        super(range, expression);
        this.expression = expression;
        this.operator = operator;
    }

    @Nonnull
    public AbstractExpressionModel getExpression() {
        return this.expression;
    }

    @Nonnull
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpressionModel that = (UnaryExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf((Object)this.operator) + " " + String.valueOf(this.expression);
    }

    public static enum Operator {
        POST_INCREMENT("++"),
        POST_DECREMENT("--"),
        PRE_INCREMENT("++"),
        PRE_DECREMENT("--"),
        POSITIVE("+"),
        NEGATIVE("-"),
        NOT("!"),
        BIT_NOT("~"),
        UNKNOWN("<unop>");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

