/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.util.Range;

public class VariableModel
extends AbstractStatementModel
implements AnnotatedModel,
NameHoldingModel {
    private final List<AnnotationExpressionModel> annotations;
    private final ModifiersModel modifiers;
    private final TypeModel type;
    private final String name;
    private final Model value;

    public VariableModel(@Nonnull Range range, @Nonnull List<AnnotationExpressionModel> annotations, @Nonnull ModifiersModel modifiers, @Nonnull TypeModel type, @Nonnull String name, @Nullable Model value) {
        super(range, ChildSupplier.of(annotations), ChildSupplier.of((Model)modifiers), ChildSupplier.of((Model)type), ChildSupplier.of(value));
        this.annotations = Collections.unmodifiableList(annotations);
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Nonnull
    public ModifiersModel getModifiers() {
        return this.modifiers;
    }

    @Nonnull
    public TypeModel getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public NameExpressionModel getNameModel() {
        return null;
    }

    @Nullable
    public Model getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableModel that = (VariableModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        if (!this.modifiers.equals(that.modifiers)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.modifiers.getModifiers().isEmpty()) {
            sb.append(this.modifiers).append(' ');
        }
        sb.append(this.type).append(' ').append(this.name);
        if (this.value != null) {
            sb.append(" = ").append(this.value);
        }
        return sb.toString();
    }
}

