/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AnnotationArgumentModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ArrayDeclarationExpressionModel;
import software.coley.sourcesolver.model.BinaryExpressionModel;
import software.coley.sourcesolver.model.CastExpressionModel;
import software.coley.sourcesolver.model.ClassModel;
import software.coley.sourcesolver.model.CompilationUnitModel;
import software.coley.sourcesolver.model.ImplementsModel;
import software.coley.sourcesolver.model.ImportModel;
import software.coley.sourcesolver.model.InstanceofExpressionModel;
import software.coley.sourcesolver.model.LiteralExpressionModel;
import software.coley.sourcesolver.model.MemberSelectExpressionModel;
import software.coley.sourcesolver.model.MethodInvocationExpressionModel;
import software.coley.sourcesolver.model.MethodModel;
import software.coley.sourcesolver.model.MethodReferenceExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.model.NewClassExpressionModel;
import software.coley.sourcesolver.model.PackageModel;
import software.coley.sourcesolver.model.ParenthesizedExpressionModel;
import software.coley.sourcesolver.model.PermitsModel;
import software.coley.sourcesolver.model.SwitchExpressionModel;
import software.coley.sourcesolver.model.ThrowStatementModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.model.TypeParameterModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.model.YieldStatementModel;
import software.coley.sourcesolver.resolve.Resolver;
import software.coley.sourcesolver.resolve.entry.ArrayEntry;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.ClassMemberPair;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;
import software.coley.sourcesolver.resolve.entry.EntryPool;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MemberEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;
import software.coley.sourcesolver.resolve.entry.PrimitiveEntry;
import software.coley.sourcesolver.resolve.entry.StaticFilteredClassEntry;
import software.coley.sourcesolver.resolve.result.ArrayResolution;
import software.coley.sourcesolver.resolve.result.ClassResolution;
import software.coley.sourcesolver.resolve.result.DescribableResolution;
import software.coley.sourcesolver.resolve.result.FieldResolution;
import software.coley.sourcesolver.resolve.result.MethodResolution;
import software.coley.sourcesolver.resolve.result.MultiClassResolution;
import software.coley.sourcesolver.resolve.result.MultiMemberResolution;
import software.coley.sourcesolver.resolve.result.NullResolution;
import software.coley.sourcesolver.resolve.result.PackageResolution;
import software.coley.sourcesolver.resolve.result.Resolution;
import software.coley.sourcesolver.resolve.result.Resolutions;
import software.coley.sourcesolver.resolve.result.ThrowingResolution;

public class BasicResolver
implements Resolver {
    private final Map<String, ClassEntry> importedTypes;
    private final CompilationUnitModel unit;
    private final EntryPool pool;

    public BasicResolver(@Nonnull CompilationUnitModel unit, @Nonnull EntryPool pool) {
        this.unit = unit;
        this.pool = pool;
        this.importedTypes = Collections.unmodifiableMap(this.populateImports());
    }

    @Nonnull
    protected CompilationUnitModel getUnit() {
        return this.unit;
    }

    @Nonnull
    protected Map<String, ClassEntry> populateImports() {
        TreeMap<String, ClassEntry> map = new TreeMap<String, ClassEntry>();
        Resolution resolution = this.unit.getPackage().resolve(this);
        if (resolution instanceof PackageResolution) {
            PackageResolution resolvedPackage = (PackageResolution)resolution;
            this.pool.getClassesInPackage(resolvedPackage.getPackageName()).forEach(entry -> map.put(entry.getName(), (ClassEntry)entry));
        }
        for (ImportModel imp : this.unit.getImports()) {
            Resolution resolution2 = imp.resolve(this);
            if (resolution2 instanceof ClassResolution) {
                ClassResolution resolvedImport = (ClassResolution)resolution2;
                ClassEntry entry2 = resolvedImport.getClassEntry();
                map.put(entry2.getName(), entry2);
                continue;
            }
            if (!(resolution2 instanceof MultiClassResolution)) continue;
            MultiClassResolution resolvedImport = (MultiClassResolution)resolution2;
            resolvedImport.getClassEntries().forEach(entry -> map.put(entry.getName(), (ClassEntry)entry));
        }
        for (ClassEntry entry3 : this.pool.getClassesInPackage("java/lang")) {
            map.put(entry3.getName(), entry3);
        }
        return map;
    }

    @Override
    @Nonnull
    public Resolution resolveAt(int position, @Nullable Model target) {
        Model child;
        if (target != null) {
            return this.resolve(target);
        }
        Model model = this.unit;
        while ((child = model.getChildAtPosition(position)) != null) {
            model = child;
        }
        return model.resolve(this);
    }

    @Nonnull
    protected Resolution resolve(@Nonnull Model target) {
        MethodModel method;
        ModifiersModel modifiers;
        Model declaringClass2;
        if (target instanceof ClassModel) {
            ClassModel clazz = (ClassModel)target;
            return this.resolveClassModel(clazz);
        }
        if (target instanceof MethodModel) {
            MethodModel method2 = (MethodModel)target;
            return this.resolveMethodModel(method2);
        }
        if (target instanceof VariableModel) {
            VariableModel variable = (VariableModel)target;
            Model model = target.getParent();
            if (model instanceof ClassModel) {
                ClassModel declaringClass2 = (ClassModel)model;
                return this.resolveFieldModel(declaringClass2, variable);
            }
            return this.resolveVariableType(variable);
        }
        if (target instanceof PackageModel) {
            PackageModel pkg = (PackageModel)target;
            return this.resolvePackageModel(pkg);
        }
        if (target instanceof ImportModel) {
            ImportModel imp = (ImportModel)target;
            return this.resolveImportModel(imp);
        }
        if (target instanceof ModifiersModel && (declaringClass2 = (modifiers = (ModifiersModel)target).getParent()) instanceof MethodModel && (method = (MethodModel)declaringClass2).getName().equals("<clinit>")) {
            return this.resolveStaticInitializer(method);
        }
        if (target instanceof AnnotationArgumentModel) {
            AnnotationArgumentModel argument = (AnnotationArgumentModel)target;
            return this.resolveAnnotationArgument(argument);
        }
        if (target instanceof AnnotationExpressionModel) {
            AnnotationExpressionModel annotation = (AnnotationExpressionModel)target;
            return annotation.getNameModel().resolve(this);
        }
        if (target instanceof MemberSelectExpressionModel) {
            MemberSelectExpressionModel memberSelectExpression = (MemberSelectExpressionModel)target;
            Model parent = memberSelectExpression.getParent();
            if (parent instanceof NewClassExpressionModel || parent instanceof TypeModel) {
                return this.resolveNamed(memberSelectExpression);
            }
            return this.resolveMemberSelection(memberSelectExpression);
        }
        if (target instanceof MethodInvocationExpressionModel) {
            MethodInvocationExpressionModel methodInvocationExpressionModel = (MethodInvocationExpressionModel)target;
            return this.resolveMethodReturnType(methodInvocationExpressionModel);
        }
        if (target instanceof NewClassExpressionModel) {
            NewClassExpressionModel newClass = (NewClassExpressionModel)target;
            return this.resolveNamed(newClass);
        }
        if (target instanceof NamedModel) {
            NamedModel named = (NamedModel)target;
            return this.resolveNameUsage(named);
        }
        if (target instanceof TypeModel) {
            TypeModel type = (TypeModel)target;
            return this.resolveType(type);
        }
        if (target instanceof CastExpressionModel) {
            CastExpressionModel cast = (CastExpressionModel)target;
            return cast.getType().resolve(this);
        }
        if (target instanceof ModifiersModel) {
            return target.getParent().resolve(this);
        }
        if (target instanceof LiteralExpressionModel) {
            LiteralExpressionModel literal = (LiteralExpressionModel)target;
            return this.resolveLiteral(literal);
        }
        if (target instanceof ArrayDeclarationExpressionModel) {
            ArrayDeclarationExpressionModel array = (ArrayDeclarationExpressionModel)target;
            return array.getType().resolve(this);
        }
        if (target instanceof ParenthesizedExpressionModel) {
            ParenthesizedExpressionModel parenthesizedExpression = (ParenthesizedExpressionModel)target;
            return parenthesizedExpression.getExpression().resolve(this);
        }
        if (target instanceof BinaryExpressionModel) {
            BinaryExpressionModel binaryExpression = (BinaryExpressionModel)target;
            return this.resolveBinaryExpression(binaryExpression);
        }
        if (target instanceof SwitchExpressionModel) {
            SwitchExpressionModel switchExpression = (SwitchExpressionModel)target;
            return this.resolveSwitchExpression(switchExpression);
        }
        if (target instanceof YieldStatementModel) {
            YieldStatementModel yieldStatementModel = (YieldStatementModel)target;
            return yieldStatementModel.getExpression().resolve(this);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveNameUsage(@Nonnull NamedModel named) {
        Resolution resolution;
        NewClassExpressionModel newExpr;
        AnnotationExpressionModel anno;
        MethodModel method;
        InstanceofExpressionModel instanceOf;
        if (named instanceof TypeModel) {
            TypeModel namedType = (TypeModel)((Object)named);
            return this.resolveType(namedType);
        }
        if (named instanceof MethodReferenceExpressionModel) {
            MethodReferenceExpressionModel methodReference = (MethodReferenceExpressionModel)named;
            return this.resolveMethodInContext(methodReference.getQualifier().resolve(this), methodReference, methodReference.getName());
        }
        Model parent = named.getParent();
        if (parent instanceof ClassModel || parent instanceof ImplementsModel || parent instanceof PermitsModel || parent instanceof CastExpressionModel || parent instanceof ThrowStatementModel || parent instanceof TypeParameterModel) {
            return this.resolveNamed(named);
        }
        if (parent instanceof InstanceofExpressionModel && (instanceOf = (InstanceofExpressionModel)parent).getType() == named) {
            return this.resolveNamed(named);
        }
        if (parent instanceof MethodModel && (named.equals((method = (MethodModel)parent).getReturnType()) || method.getThrownTypes().contains(named))) {
            return this.resolveNamed(named);
        }
        if (parent instanceof AnnotationExpressionModel && named.equals((anno = (AnnotationExpressionModel)parent).getNameModel())) {
            return this.resolveNamed(named);
        }
        if (parent instanceof NewClassExpressionModel && (newExpr = (NewClassExpressionModel)parent).getIdentifier() == named) {
            return this.resolveNamed(newExpr);
        }
        if (parent instanceof TypeModel) {
            TypeModel parentType = (TypeModel)parent;
            return this.resolveType(parentType);
        }
        if (parent instanceof PackageModel) {
            PackageModel parentPackage = (PackageModel)parent;
            return this.resolvePackageModel(parentPackage);
        }
        if (parent instanceof MemberSelectExpressionModel) {
            resolution = this.resolveNamed(named);
            if (!resolution.isUnknown()) {
                return resolution;
            }
        } else {
            MethodInvocationExpressionModel methodInvocation;
            if (parent instanceof MethodInvocationExpressionModel && named == (methodInvocation = (MethodInvocationExpressionModel)parent).getMethodSelect()) {
                return this.resolveMember(methodInvocation);
            }
            if (parent instanceof MethodReferenceExpressionModel) {
                MethodReferenceExpressionModel methodReference = (MethodReferenceExpressionModel)parent;
                if (named == methodReference.getNameModel()) {
                    return this.resolveNameUsage(methodReference);
                }
                if (named == methodReference.getQualifier() && named instanceof NameExpressionModel && !(resolution = this.resolveNamed(named)).isUnknown()) {
                    return resolution;
                }
            }
        }
        String name = named.getName();
        MethodModel containingMethod = named.getParentOfType(MethodModel.class);
        if (containingMethod != null) {
            List<VariableModel> variables = containingMethod.getRecursiveChildrenOfType(VariableModel.class);
            for (VariableModel variable : variables) {
                Resolution resolution2;
                if (!variable.getName().equals(name) || (resolution2 = this.resolveType(variable.getType())).isUnknown()) continue;
                return resolution2;
            }
        }
        if (!(resolution = this.resolveMemberByNameInModel(named, named.getName(), MemberTarget.FIELDS)).isUnknown()) {
            return resolution;
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveDotName(@Nonnull String name) {
        name = ((String)name).replace('.', '/');
        Resolution resolution = Resolutions.ofClass(this.pool, (String)name);
        while (resolution.isUnknown() && ((String)name).indexOf(47) >= 0) {
            int lastSlash = ((String)name).lastIndexOf(47);
            String tail = ((String)name).substring(lastSlash + 1);
            name = ((String)name).substring(0, lastSlash) + "$" + tail;
            resolution = Resolutions.ofClass(this.pool, (String)name);
        }
        return resolution;
    }

    @Nonnull
    private Resolution resolveNamed(@Nonnull NamedModel named) {
        Resolution resolution = this.resolveNameAsQualifiedOrImported(named.getName());
        if (!resolution.isUnknown()) {
            return resolution;
        }
        resolution = this.resolveAsInnerClass(named.getName());
        if (!resolution.isUnknown()) {
            return resolution;
        }
        resolution = this.resolveAsTypeArgument(named, named.getName());
        if (!resolution.isUnknown()) {
            return resolution;
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveAsInnerClass(@Nonnull String name) {
        String packageName = this.unit.getPackage().getName();
        for (ClassModel cls : this.unit.getRecursiveChildrenOfType(ClassModel.class)) {
            ClassEntry entry;
            String localClassName = cls.getName();
            if (!localClassName.equals(name)) continue;
            StringBuilder nameBuilder = new StringBuilder(localClassName);
            for (ClassModel outerCls = cls.getParentOfType(ClassModel.class); outerCls != null; outerCls = outerCls.getParentOfType(ClassModel.class)) {
                nameBuilder.insert(0, outerCls.getName() + "$");
            }
            if (!packageName.isEmpty()) {
                nameBuilder.insert(0, packageName.replace('.', '/') + "/");
            }
            if ((entry = this.pool.getClass(nameBuilder.toString())) == null) continue;
            return Resolutions.ofClass(entry);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveNameAsQualifiedOrImported(@Nonnull String name) {
        if (name.indexOf(46) > 0) {
            return this.resolveDotName(name);
        }
        for (Map.Entry<String, ClassEntry> importEntry : this.importedTypes.entrySet()) {
            if (!importEntry.getKey().endsWith("/" + name)) continue;
            return Resolutions.ofClass(importEntry.getValue());
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveAsTypeArgument(@Nonnull Model origin, @Nonnull String name) {
        for (ClassModel cls = origin.getParentOfType(ClassModel.class); cls != null; cls = cls.getParentOfType(ClassModel.class)) {
            for (TypeParameterModel typeParameter : cls.getTypeParameters()) {
                if (!typeParameter.getName().equals(name)) continue;
                return typeParameter.getBounds().stream().map(b -> b.resolve(this)).reduce(Resolutions::mergeWith).orElse(Resolutions.ofClass(Objects.requireNonNull(this.pool.getClass("java/lang/Object"))));
            }
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveType(@Nonnull TypeModel type) {
        TypeModel.Array arrayType;
        Model elementType;
        Resolution elementResolution;
        TypeModel.Kind kind = type.getKind();
        if (kind == TypeModel.Kind.PRIMITIVE && type instanceof TypeModel.Primitive) {
            TypeModel.Primitive primitiveType = (TypeModel.Primitive)type;
            return switch (primitiveType.getPrimitiveKind()) {
                case TypeKind.BOOLEAN -> Resolutions.ofPrimitive("Z");
                case TypeKind.BYTE -> Resolutions.ofPrimitive("B");
                case TypeKind.SHORT -> Resolutions.ofPrimitive("S");
                case TypeKind.INT -> Resolutions.ofPrimitive("I");
                case TypeKind.LONG -> Resolutions.ofPrimitive("J");
                case TypeKind.CHAR -> Resolutions.ofPrimitive("C");
                case TypeKind.FLOAT -> Resolutions.ofPrimitive("F");
                case TypeKind.DOUBLE -> Resolutions.ofPrimitive("D");
                case TypeKind.VOID -> Resolutions.ofPrimitive("V");
                default -> Resolutions.unknown();
            };
        }
        if (kind == TypeModel.Kind.OBJECT || kind == TypeModel.Kind.PARAMETERIZED) {
            return this.resolveAsIdentifier(type.getIdentifier());
        }
        if (kind == TypeModel.Kind.UNION && type instanceof TypeModel.Union) {
            TypeModel.Union union = (TypeModel.Union)type;
            ClassEntry common = null;
            for (TypeModel unionArgType : union.getAllTypes()) {
                Resolution resolution = this.resolveType(unionArgType);
                if (!(resolution instanceof ClassResolution)) continue;
                ClassResolution classResolution = (ClassResolution)resolution;
                ClassEntry resolvedClass = classResolution.getClassEntry();
                common = common == null ? resolvedClass : common.getCommonParent(resolvedClass);
            }
            if (common != null) {
                return Resolutions.ofClass(common);
            }
        } else if (kind == TypeModel.Kind.ARRAY && type instanceof TypeModel.Array && (elementResolution = this.resolveAsIdentifier(elementType = (arrayType = (TypeModel.Array)type).getRootModel())) instanceof DescribableResolution) {
            DescribableResolution describableElementResolution = (DescribableResolution)elementResolution;
            return Resolutions.ofArray(describableElementResolution, arrayType.getDimensions());
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveAsIdentifier(@Nonnull Model identifier) {
        if (identifier instanceof TypeModel) {
            TypeModel typeIdentifier = (TypeModel)identifier;
            return this.resolveType(typeIdentifier);
        }
        if (identifier instanceof NamedModel) {
            NamedModel named = (NamedModel)identifier;
            return this.resolveNamed(named);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolvePackageModel(@Nonnull PackageModel pkg) {
        String packageName = pkg.isDefaultPackage() ? null : pkg.getName().replace('.', '/');
        return Resolutions.ofPackage(packageName);
    }

    @Nonnull
    private Resolution resolveImportModel(@Nonnull ImportModel imp) {
        String name = imp.getName();
        if (imp.isStatic()) {
            int lastDot = name.lastIndexOf(46);
            String className = name.substring(0, lastDot);
            String memberName = name.substring(lastDot + 1);
            Resolution resolution = this.resolveDotName(className);
            if (resolution instanceof ClassResolution) {
                ClassResolution declaringClassResolution = (ClassResolution)resolution;
                ArrayList<ClassMemberPair> memberEntries = new ArrayList<ClassMemberPair>();
                if (memberName.lastIndexOf(42) >= 0) {
                    declaringClassResolution.getClassEntry().visitHierarchy(owner -> memberEntries.addAll(owner.declaredMemberStream().filter(e -> !e.isPrivate() && e.isStatic()).map(e -> new ClassMemberPair((ClassEntry)owner, (MemberEntry)e)).toList()));
                } else {
                    declaringClassResolution.getClassEntry().visitHierarchy(owner -> memberEntries.addAll(owner.declaredMemberStream().filter(e -> !e.isPrivate() && e.isStatic() && e.getName().equals(memberName)).map(e -> new ClassMemberPair((ClassEntry)owner, (MemberEntry)e)).toList()));
                }
                return Resolutions.ofMembers(memberEntries);
            }
            return Resolutions.unknown();
        }
        if (name.endsWith(".*")) {
            String packageName = name.substring(0, name.lastIndexOf(".*")).replace('.', '/');
            return Resolutions.ofClasses(this.pool.getClassesInPackage(packageName));
        }
        return this.resolveNameAsQualifiedOrImported(name);
    }

    @Nonnull
    private Resolution resolveClassModel(@Nonnull ClassModel clazz) {
        Resolution resolution;
        String name = clazz.getName();
        ClassModel outerClass = clazz.getParentOfType(ClassModel.class);
        if (outerClass != null && (resolution = this.resolveClassModel(outerClass)) instanceof ClassResolution) {
            ClassResolution outerResolution = (ClassResolution)resolution;
            return this.resolveDotName(outerResolution.getClassEntry().getName() + "." + name);
        }
        if (this.unit.getPackage().isDefaultPackage()) {
            return Resolutions.ofClass(this.pool, name);
        }
        return this.resolveDotName(this.unit.getPackage().getName() + "." + name);
    }

    @Nonnull
    private Resolution resolveAnnotationArgument(@Nonnull AnnotationArgumentModel argument) {
        Resolution containingAnnotationResolution = Objects.requireNonNull(argument.getParent()).resolve(this);
        if (!containingAnnotationResolution.isUnknown()) {
            return this.resolveMethodInContext(containingAnnotationResolution, argument, argument.getName());
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveFieldModel(@Nonnull ClassModel definingClass, @Nonnull VariableModel field) {
        Resolution resolution = definingClass.resolve(this);
        if (!(resolution instanceof ClassResolution)) {
            return Resolutions.unknown();
        }
        ClassResolution resolvedDefiningClass = (ClassResolution)resolution;
        String fieldName = field.getName();
        ClassEntry definingClassEntry = resolvedDefiningClass.getClassEntry();
        Resolution resolution2 = this.resolveFieldByNameInClass(definingClassEntry, fieldName, null);
        if (resolution2 instanceof FieldResolution) {
            FieldResolution resolution3 = (FieldResolution)resolution2;
            return resolution3;
        }
        resolution2 = field.getType().resolve(this);
        if (resolution2 instanceof DescribableResolution) {
            DescribableResolution resolvedType = (DescribableResolution)resolution2;
            return Resolutions.ofField(definingClassEntry, fieldName, resolvedType.getDescribableEntry().getDescriptor());
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMethodModel(@Nonnull MethodModel method) {
        Resolution resolution;
        Model model = method.getParent();
        if (!(model instanceof ClassModel)) {
            return Resolutions.unknown();
        }
        ClassModel definingClass = (ClassModel)model;
        Resolution resolution2 = definingClass.resolve(this);
        if (!(resolution2 instanceof ClassResolution)) {
            return Resolutions.unknown();
        }
        ClassResolution resolvedDefiningClass = (ClassResolution)resolution2;
        String methodName = method.getName();
        ClassEntry definingClassEntry = resolvedDefiningClass.getClassEntry();
        Resolution byNameResolution = null;
        if (methodName.charAt(0) == '<') {
            Resolution resolution3 = this.resolveMethodByNameInClass(definingClassEntry, methodName, PrimitiveEntry.getPrimitive("V"), null);
            if (resolution3 instanceof MethodResolution) {
                resolution = (MethodResolution)resolution3;
                byNameResolution = resolution;
            }
        } else {
            resolution = this.resolveMethodByNameInClass(definingClassEntry, methodName);
            if (resolution instanceof MethodResolution) {
                MethodResolution resolution4 = (MethodResolution)resolution;
                byNameResolution = resolution4;
            }
        }
        if (byNameResolution != null && byNameResolution.getOwnerEntry() == definingClassEntry) {
            return byNameResolution;
        }
        resolution = method.getReturnType().resolve(this);
        if (!(resolution instanceof DescribableResolution)) {
            return Resolutions.unknown();
        }
        DescribableResolution resolvedReturnType = (DescribableResolution)resolution;
        List<VariableModel> parameters = method.getParameters();
        ArrayList<DescribableResolution> resolvedParameterTypes = new ArrayList<DescribableResolution>(parameters.size());
        for (VariableModel parameter : parameters) {
            Resolution resolution5 = parameter.resolve(this);
            if (resolution5 instanceof DescribableResolution) {
                DescribableResolution resolvedParameter = (DescribableResolution)resolution5;
                resolvedParameterTypes.add(resolvedParameter);
                continue;
            }
            return Resolutions.unknown();
        }
        return Resolutions.ofMethod(definingClassEntry, methodName, resolvedReturnType.getDescribableEntry(), resolvedParameterTypes.stream().map(DescribableResolution::getDescribableEntry).toList());
    }

    @Nonnull
    private Resolution resolveFieldByNameInClass(@Nonnull ClassEntry declaringClass, @Nonnull String fieldName, @Nullable DescribableEntry typeEntryHint) {
        Resolution resolution;
        if (fieldName.equals("this")) {
            return Resolutions.ofClass(declaringClass);
        }
        if (fieldName.equals("class")) {
            return Resolutions.ofClass(Objects.requireNonNull(this.pool.getClass("java/lang/Class")));
        }
        List<FieldEntry> fieldsByName = declaringClass.getDeclaredFieldsByName(fieldName);
        if (fieldsByName.size() == 1) {
            return Resolutions.ofField(declaringClass, fieldsByName.getFirst());
        }
        if (declaringClass.getSuperEntry() != null && (resolution = this.resolveFieldByNameInClass(declaringClass.getSuperEntry(), fieldName, typeEntryHint)) instanceof FieldResolution) {
            FieldResolution resolution2 = (FieldResolution)resolution;
            return resolution2;
        }
        for (ClassEntry implementedEntry : declaringClass.getImplementedEntries()) {
            Resolution resolution3 = this.resolveFieldByNameInClass(implementedEntry, fieldName, typeEntryHint);
            if (!(resolution3 instanceof FieldResolution)) continue;
            FieldResolution resolution4 = (FieldResolution)resolution3;
            return resolution4;
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMethodByNameInClass(@Nonnull ClassEntry classEntry, @Nonnull String methodName) {
        return this.resolveMethodByNameInClass(classEntry, methodName, null, null);
    }

    @Nonnull
    private Resolution resolveMethodByNameInClass(@Nonnull ClassEntry classEntry, @Nonnull String methodName, @Nullable DescribableEntry returnTypeEntry, @Nullable List<DescribableEntry> argumentTypeEntries) {
        Object methodEntry;
        List<MethodEntry> methodsByName = classEntry.getDeclaredMethodsByName(methodName);
        if (methodsByName.size() == 1) {
            return Resolutions.ofMethod(classEntry, methodsByName.getFirst());
        }
        if (methodsByName.size() > 1 && (returnTypeEntry != null || argumentTypeEntries != null)) {
            block0: for (int i = methodsByName.size() - 1; i >= 0; --i) {
                int maxArgToCheck;
                DescribableEntry describableReturn;
                methodEntry = methodsByName.get(i);
                if (returnTypeEntry != null && (describableReturn = this.pool.getDescribable(methodEntry.getReturnDescriptor())) != null && !describableReturn.isAssignableFrom(returnTypeEntry)) {
                    methodsByName.remove(methodEntry);
                    continue;
                }
                if (argumentTypeEntries == null) continue;
                List<String> argumentDescriptors = methodEntry.getParameterDescriptors();
                int hintedArgCount = argumentTypeEntries.size();
                int actualArgCount = argumentDescriptors.size();
                if (methodEntry.isVarargs()) {
                    DescribableEntry varargElementType;
                    maxArgToCheck = actualArgCount - 1;
                    if (hintedArgCount < maxArgToCheck) {
                        methodsByName.remove(methodEntry);
                        break;
                    }
                    String varargParameterDescriptor = argumentDescriptors.getLast();
                    if (varargParameterDescriptor.charAt(0) == '[') {
                        varargParameterDescriptor = varargParameterDescriptor.substring(1);
                    }
                    if ((varargElementType = this.pool.getDescribable(varargParameterDescriptor)) != null) {
                        boolean methodRemoved = false;
                        for (int j = maxArgToCheck; j < hintedArgCount; ++j) {
                            if (varargElementType.isAssignableFrom(argumentTypeEntries.get(j))) continue;
                            methodRemoved = true;
                            methodsByName.remove(methodEntry);
                            break;
                        }
                        if (methodRemoved) {
                            continue;
                        }
                    }
                } else {
                    maxArgToCheck = actualArgCount;
                    if (hintedArgCount != actualArgCount) {
                        methodsByName.remove(methodEntry);
                        continue;
                    }
                }
                for (int j = 0; j < maxArgToCheck; ++j) {
                    String parameterDescriptor = argumentDescriptors.get(j);
                    DescribableEntry describableParameter = this.pool.getDescribable(parameterDescriptor);
                    if (describableParameter == null || describableParameter.isAssignableFrom(argumentTypeEntries.get(j))) continue;
                    methodsByName.remove(methodEntry);
                    continue block0;
                }
            }
            if (methodsByName.size() == 1) {
                return Resolutions.ofMethod(classEntry, methodsByName.getFirst());
            }
            if (argumentTypeEntries != null) {
                String argsDesc = "(" + argumentTypeEntries.stream().map(DescribableEntry::getDescriptor).collect(Collectors.joining("")) + ")";
                if ((methodsByName = methodsByName.stream().filter(e -> e.getDescriptor().startsWith(argsDesc)).collect(Collectors.toList())).size() == 1) {
                    return Resolutions.ofMethod(classEntry, methodsByName.getFirst());
                }
            }
        }
        if (methodName.charAt(0) != '<') {
            if (classEntry.getSuperEntry() != null && (methodEntry = this.resolveMethodByNameInClass(classEntry.getSuperEntry(), methodName, returnTypeEntry, argumentTypeEntries)) instanceof MethodResolution) {
                MethodResolution resolution = (MethodResolution)methodEntry;
                return resolution;
            }
            for (ClassEntry implementedEntry : classEntry.getImplementedEntries()) {
                Resolution resolution = this.resolveMethodByNameInClass(implementedEntry, methodName, returnTypeEntry, argumentTypeEntries);
                if (!(resolution instanceof MethodResolution)) continue;
                MethodResolution resolution2 = (MethodResolution)resolution;
                return resolution2;
            }
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMemberByNameInModel(@Nonnull Model origin, @Nonnull String name, @Nonnull MemberTarget target) {
        AnnotationArgumentModel annotationArgument;
        Model model = origin.getParent();
        if (model instanceof AnnotationArgumentModel && (annotationArgument = (AnnotationArgumentModel)model).getName().equals(name)) {
            return annotationArgument.resolve(this);
        }
        boolean isFieldsTarget = target == MemberTarget.FIELDS;
        boolean wasLastClassContextStatic = false;
        for (ClassModel classContext = origin.getParentOfType(ClassModel.class); classContext != null; classContext = classContext.getParentOfType(ClassModel.class)) {
            Resolution resolution;
            Resolution resolution2 = this.resolveClassModel(classContext);
            if (!(resolution2 instanceof ClassResolution)) continue;
            ClassResolution classResolution = (ClassResolution)resolution2;
            ClassEntry classEntry = wasLastClassContextStatic ? new StaticFilteredClassEntry(classResolution.getClassEntry()) : classResolution.getClassEntry();
            Resolution resolution3 = resolution = isFieldsTarget ? this.resolveFieldByNameInClass(classEntry, name, null) : this.resolveMethodByNameInClass(classEntry, name, null, this.collectMethodArgumentsInParentContext(origin));
            if (!resolution.isUnknown()) {
                return resolution;
            }
            wasLastClassContextStatic = classEntry.isStatic();
        }
        String namedStaticImportPattern = "." + name;
        for (ImportModel imp : this.unit.getImports()) {
            MethodResolution methodResolution;
            if (!imp.isStatic() || !imp.getName().endsWith(namedStaticImportPattern) && !imp.getName().endsWith(".*")) continue;
            Resolution importResolution = this.resolveImportModel(imp);
            if (isFieldsTarget) {
                FieldResolution fieldResolution;
                if (importResolution instanceof FieldResolution && (fieldResolution = (FieldResolution)importResolution).getFieldEntry().getName().equals(name)) {
                    return fieldResolution;
                }
                if (!(importResolution instanceof MultiMemberResolution)) continue;
                MultiMemberResolution multiMemberresolution = (MultiMemberResolution)importResolution;
                for (ClassMemberPair pair : multiMemberresolution.getMemberEntries()) {
                    MemberEntry memberEntry = pair.memberEntry();
                    if (!memberEntry.isField() || !memberEntry.getName().equals(name)) continue;
                    return Resolutions.ofMember(pair);
                }
                continue;
            }
            if (!(origin instanceof MethodInvocationExpressionModel)) continue;
            MethodInvocationExpressionModel invocation = (MethodInvocationExpressionModel)origin;
            if (importResolution instanceof MethodResolution && (methodResolution = (MethodResolution)importResolution).getMethodEntry().getName().equals(name)) {
                return this.resolveMemberInContext(methodResolution.getOwnerResolution(), invocation, name);
            }
            if (!(importResolution instanceof MultiMemberResolution)) continue;
            MultiMemberResolution multiMemberresolution = (MultiMemberResolution)importResolution;
            for (ClassMemberPair pair : multiMemberresolution.getMemberEntries()) {
                Resolution entryResolution;
                MemberEntry memberEntry = pair.memberEntry();
                if (!memberEntry.isMethod() || !memberEntry.getName().equals(name) || (entryResolution = this.resolveMemberInContext(Resolutions.ofClass(pair.ownerEntry()), invocation, name)).isUnknown()) continue;
                return entryResolution;
            }
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveStaticInitializer(@Nonnull MethodModel method) {
        Model model = method.getParent();
        if (!(model instanceof ClassModel)) {
            return Resolutions.unknown();
        }
        ClassModel definingClass = (ClassModel)model;
        Resolution resolution = definingClass.resolve(this);
        if (!(resolution instanceof ClassResolution)) {
            return Resolutions.unknown();
        }
        ClassResolution resolvedDefiningClass = (ClassResolution)resolution;
        List<MethodEntry> initializers = resolvedDefiningClass.getClassEntry().getDeclaredMethodsByName("<clinit>");
        if (initializers.isEmpty()) {
            return Resolutions.unknown();
        }
        return Resolutions.ofMethod(resolvedDefiningClass.getClassEntry(), initializers.getFirst());
    }

    @Nonnull
    private Resolution resolveVariableType(@Nonnull VariableModel variable) {
        TypeModel type = variable.getType();
        if (type.getKind() == TypeModel.Kind.VAR) {
            return Resolutions.unknown();
        }
        return this.resolveType(type);
    }

    @Nonnull
    private Resolution resolveMember(@Nonnull MethodInvocationExpressionModel methodInvocation) {
        AbstractExpressionModel select = methodInvocation.getMethodSelect();
        if (select instanceof MemberSelectExpressionModel) {
            MemberSelectExpressionModel memberSelect = (MemberSelectExpressionModel)select;
            return this.resolveMemberSelection(memberSelect);
        }
        if (select instanceof NameExpressionModel) {
            NameExpressionModel named = (NameExpressionModel)select;
            return this.resolveMemberByNameInModel(methodInvocation, named.getName(), MemberTarget.METHODS);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMemberSelection(@Nonnull MemberSelectExpressionModel memberSelect) {
        String memberName = memberSelect.getName();
        Resolution contextResolution = memberSelect.getContext().resolve(this);
        return this.resolveMemberInContext(contextResolution, memberSelect, memberName);
    }

    @Nonnull
    private Resolution resolveMemberInContext(@Nonnull Resolution contextResolution, @Nonnull Model origin, @Nonnull String memberName) {
        if (contextResolution instanceof ClassResolution) {
            ClassResolution classResolution = (ClassResolution)contextResolution;
            if (origin instanceof MethodInvocationExpressionModel) {
                return this.resolveMethodInContext(contextResolution, origin, memberName);
            }
            if (origin instanceof MemberSelectExpressionModel) {
                MethodInvocationExpressionModel invoke;
                Model model = origin.getParent();
                if (model instanceof MethodInvocationExpressionModel && (invoke = (MethodInvocationExpressionModel)model).getMethodSelect() == origin) {
                    return this.resolveMethodInContext(contextResolution, origin, memberName);
                }
                return this.resolveFieldInContext(contextResolution, origin, memberName);
            }
            Resolution resolution = this.resolveFieldInContext(contextResolution, origin, memberName);
            if (resolution.isUnknown()) {
                resolution = this.resolveMethodInContext(contextResolution, origin, memberName);
            }
            return resolution;
        }
        if (contextResolution instanceof FieldResolution) {
            FieldResolution fieldResolution = (FieldResolution)contextResolution;
            DescribableEntry describableFieldType = this.pool.getDescribable(fieldResolution.getFieldEntry().getDescriptor());
            if (describableFieldType != null) {
                return this.resolveMemberInContext(Resolutions.ofDescribable(describableFieldType), origin, memberName);
            }
        } else if (contextResolution instanceof MethodResolution) {
            MethodResolution methodResolution = (MethodResolution)contextResolution;
            DescribableEntry describableReturnType = this.pool.getDescribable(methodResolution.getMethodEntry().getReturnDescriptor());
            if (describableReturnType != null) {
                return this.resolveMemberInContext(Resolutions.ofDescribable(describableReturnType), origin, memberName);
            }
        } else if (contextResolution instanceof ArrayResolution) {
            ArrayResolution arrayResolution = (ArrayResolution)contextResolution;
            Resolution resolution = this.resolveFieldInContext(contextResolution, origin, memberName);
            if (!resolution.isUnknown()) {
                return resolution;
            }
            return this.resolveMemberInContext(Resolutions.ofClass(Objects.requireNonNull(this.pool.getClass("java/lang/Object"))), origin, memberName);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveFieldInContext(@Nonnull Resolution contextResolution, @Nonnull Model origin, @Nonnull String fieldName) {
        DescribableEntry usageType = null;
        if (contextResolution instanceof ClassResolution) {
            ClassResolution classResolution = (ClassResolution)contextResolution;
            ClassEntry declaringClass = classResolution.getClassEntry();
            return this.resolveFieldByNameInClass(declaringClass, fieldName, usageType);
        }
        if (contextResolution instanceof FieldResolution) {
            FieldResolution fieldResolution = (FieldResolution)contextResolution;
            DescribableEntry describableFieldType = this.pool.getDescribable(fieldResolution.getFieldEntry().getDescriptor());
            if (describableFieldType instanceof ClassEntry) {
                ClassEntry declaringClass = (ClassEntry)describableFieldType;
                return this.resolveFieldByNameInClass(declaringClass, fieldName, usageType);
            }
            if (describableFieldType instanceof ArrayEntry) {
                if (fieldName.equals("length")) {
                    return Resolutions.ofPrimitive(PrimitiveEntry.INT);
                }
                return this.resolveFieldByNameInClass(Objects.requireNonNull(this.pool.getClass("java/lang/Object")), fieldName, usageType);
            }
        } else if (contextResolution instanceof MethodResolution) {
            MethodResolution methodResolution = (MethodResolution)contextResolution;
            DescribableEntry describableEntry = this.pool.getDescribable(methodResolution.getMethodEntry().getReturnDescriptor());
            if (describableEntry instanceof ClassEntry) {
                ClassEntry declaringClass = (ClassEntry)describableEntry;
                return this.resolveFieldByNameInClass(declaringClass, fieldName, usageType);
            }
        } else if (contextResolution instanceof ArrayResolution) {
            if (fieldName.equals("length")) {
                return Resolutions.ofPrimitive(PrimitiveEntry.INT);
            }
            return this.resolveFieldByNameInClass(Objects.requireNonNull(this.pool.getClass("java/lang/Object")), fieldName, usageType);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMethodInContext(@Nonnull Resolution contextResolution, @Nonnull Model origin, @Nonnull String methodName) {
        MethodResolution methodResolution;
        DescribableEntry describableEntry;
        DescribableEntry returnType = null;
        List<DescribableEntry> describableArguments = this.collectMethodArgumentsInParentContext(origin);
        if (contextResolution instanceof ClassResolution) {
            ClassResolution classResolution = (ClassResolution)contextResolution;
            ClassEntry declaringClass = classResolution.getClassEntry();
            return this.resolveMethodByNameInClass(declaringClass, methodName, returnType, describableArguments);
        }
        if (contextResolution instanceof FieldResolution) {
            FieldResolution fieldResolution = (FieldResolution)contextResolution;
            DescribableEntry describableEntry2 = this.pool.getDescribable(fieldResolution.getFieldEntry().getDescriptor());
            if (describableEntry2 instanceof ClassEntry) {
                ClassEntry declaringClass = (ClassEntry)describableEntry2;
                return this.resolveMethodByNameInClass(declaringClass, methodName, returnType, describableArguments);
            }
        } else if (contextResolution instanceof MethodResolution && (describableEntry = this.pool.getDescribable((methodResolution = (MethodResolution)contextResolution).getMethodEntry().getReturnDescriptor())) instanceof ClassEntry) {
            ClassEntry declaringClass = (ClassEntry)describableEntry;
            return this.resolveMethodByNameInClass(declaringClass, methodName, returnType, describableArguments);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveMethodReturnType(@Nonnull MethodInvocationExpressionModel methodInvocation) {
        Resolution resolution = this.resolveMember(methodInvocation);
        if (resolution instanceof MethodResolution) {
            MethodResolution resolvedInvocation = (MethodResolution)resolution;
            DescribableEntry returnValueEntry = this.pool.getDescribable(resolvedInvocation.getMethodEntry().getReturnDescriptor());
            if (returnValueEntry instanceof ArrayEntry) {
                ArrayEntry array = (ArrayEntry)returnValueEntry;
                return Resolutions.ofArray(array);
            }
            if (returnValueEntry instanceof PrimitiveEntry) {
                PrimitiveEntry primitive = (PrimitiveEntry)returnValueEntry;
                return Resolutions.ofPrimitive(primitive);
            }
            if (returnValueEntry instanceof ClassEntry) {
                ClassEntry clazz = (ClassEntry)returnValueEntry;
                return Resolutions.ofClass(clazz);
            }
        }
        return Resolutions.unknown();
    }

    @Nonnull
    private Resolution resolveSwitchExpression(@Nonnull SwitchExpressionModel switchExpr) {
        List<Resolution> caseResolutions = switchExpr.getCases().stream().map(m -> {
            List<Model> models = m.getBody() != null ? Collections.singletonList(m.getBody()) : m.getExpressions();
            for (Model model : models) {
                Resolution expressionResolution;
                if (model instanceof AbstractExpressionModel && !(expressionResolution = model.resolve(this)).isUnknown()) {
                    return expressionResolution;
                }
                List<YieldStatementModel> yieldChildren = model.getRecursiveChildrenOfType(YieldStatementModel.class);
                for (YieldStatementModel yieldChild : yieldChildren) {
                    Resolution resolvedYieldValueType = yieldChild.resolve(this);
                    if (resolvedYieldValueType.isUnknown()) continue;
                    return resolvedYieldValueType;
                }
                List<ThrowStatementModel> throwsChildren = model.getRecursiveChildrenOfType(ThrowStatementModel.class);
                if (throwsChildren.isEmpty()) continue;
                return Resolutions.throwing();
            }
            return Resolutions.unknown();
        }).filter(r -> !(r instanceof ThrowingResolution) && !(r instanceof NullResolution)).map(r -> {
            if (r instanceof FieldResolution) {
                FieldResolution fieldResolution = (FieldResolution)r;
                DescribableEntry fieldDescription = this.pool.getDescribable(fieldResolution.getFieldEntry().getDescriptor());
                if (fieldDescription != null) {
                    return Resolutions.ofDescribable(fieldDescription);
                }
                return Resolutions.unknown();
            }
            if (r instanceof MethodResolution) {
                MethodResolution methodResolution = (MethodResolution)r;
                DescribableEntry methodReturnDescription = this.pool.getDescribable(methodResolution.getMethodEntry().getReturnDescriptor());
                if (methodReturnDescription != null) {
                    return Resolutions.ofDescribable(methodReturnDescription);
                }
                return Resolutions.unknown();
            }
            return r;
        }).toList();
        if (caseResolutions.isEmpty() || caseResolutions.stream().anyMatch(Resolution::isUnknown)) {
            return Resolutions.unknown();
        }
        return caseResolutions.stream().reduce(Resolutions::mergeWith).orElse(Resolutions.unknown());
    }

    @Nonnull
    private Resolution resolveBinaryExpression(@Nonnull BinaryExpressionModel binary) {
        return switch (binary.getOperator()) {
            default -> throw new MatchException(null, null);
            case BinaryExpressionModel.Operator.PLUS -> Resolutions.mergeWith(Resolutions.MergeOp.ADDITION_OR_CONCAT, binary.getLeft().resolve(this), binary.getRight().resolve(this));
            case BinaryExpressionModel.Operator.MINUS, BinaryExpressionModel.Operator.MULTIPLY, BinaryExpressionModel.Operator.DIVIDE, BinaryExpressionModel.Operator.REMAINDER, BinaryExpressionModel.Operator.BIT_OR, BinaryExpressionModel.Operator.BIT_AND, BinaryExpressionModel.Operator.BIT_XOR, BinaryExpressionModel.Operator.SHIFT_LEFT, BinaryExpressionModel.Operator.SHIFT_RIGHT, BinaryExpressionModel.Operator.SHIFT_RIGHT_UNSIGNED -> Resolutions.mergeWith(binary.getLeft().resolve(this), binary.getRight().resolve(this));
            case BinaryExpressionModel.Operator.EQUALS, BinaryExpressionModel.Operator.NOT_EQUALS, BinaryExpressionModel.Operator.CONDITIONAL_OR, BinaryExpressionModel.Operator.CONDITIONAL_AND, BinaryExpressionModel.Operator.RELATION_LESS, BinaryExpressionModel.Operator.RELATION_GREATER, BinaryExpressionModel.Operator.RELATION_LESS_EQUAL, BinaryExpressionModel.Operator.RELATION_GREATER_EQUAL, BinaryExpressionModel.Operator.RELATION_INSTANCEOF -> Resolutions.ofPrimitive(PrimitiveEntry.BOOLEAN);
            case BinaryExpressionModel.Operator.UNKNOWN -> Resolutions.unknown();
        };
    }

    @Nonnull
    private Resolution resolveLiteral(@Nonnull LiteralExpressionModel literal) {
        return switch (literal.getKind()) {
            case LiteralExpressionModel.Kind.INT -> Resolutions.ofPrimitive(PrimitiveEntry.INT);
            case LiteralExpressionModel.Kind.LONG -> Resolutions.ofPrimitive(PrimitiveEntry.LONG);
            case LiteralExpressionModel.Kind.FLOAT -> Resolutions.ofPrimitive(PrimitiveEntry.FLOAT);
            case LiteralExpressionModel.Kind.DOUBLE -> Resolutions.ofPrimitive(PrimitiveEntry.DOUBLE);
            case LiteralExpressionModel.Kind.BOOLEAN -> Resolutions.ofPrimitive(PrimitiveEntry.BOOLEAN);
            case LiteralExpressionModel.Kind.CHAR -> Resolutions.ofPrimitive(PrimitiveEntry.CHAR);
            case LiteralExpressionModel.Kind.STRING -> Resolutions.ofClass(this.pool, "java/lang/String");
            case LiteralExpressionModel.Kind.NULL -> Resolutions.nul();
            default -> Resolutions.unknown();
        };
    }

    @Nullable
    private List<DescribableEntry> collectMethodArgumentsInParentContext(@Nonnull Model origin) {
        MethodInvocationExpressionModel invoke;
        MethodInvocationExpressionModel methodInvocation;
        if (origin instanceof MethodReferenceExpressionModel) {
            return null;
        }
        MethodInvocationExpressionModel methodInvocationExpressionModel = methodInvocation = origin instanceof MethodInvocationExpressionModel ? (invoke = (MethodInvocationExpressionModel)origin) : origin.getParentOfType(MethodInvocationExpressionModel.class);
        if (methodInvocation == null) {
            return null;
        }
        List<AbstractExpressionModel> arguments = methodInvocation.getArguments();
        ArrayList<DescribableEntry> describableArguments = arguments.isEmpty() ? Collections.emptyList() : new ArrayList<DescribableEntry>(arguments.size());
        for (AbstractExpressionModel argument : arguments) {
            Resolution resolution = argument.resolve(this);
            if (resolution instanceof DescribableResolution) {
                DescribableResolution describableResolution = (DescribableResolution)resolution;
                DescribableEntry argumentDescribableEntry = describableResolution.getDescribableEntry();
                if (argumentDescribableEntry instanceof FieldEntry) {
                    describableArguments.add(this.pool.getDescribable(argumentDescribableEntry.getDescriptor()));
                    continue;
                }
                describableArguments.add(argumentDescribableEntry);
                continue;
            }
            return null;
        }
        return describableArguments;
    }

    private static enum MemberTarget {
        FIELDS,
        METHODS;

    }
}

