/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.resolve.entry.BasicArrayEntry;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;
import software.coley.sourcesolver.resolve.entry.NullEntry;

public non-sealed interface ArrayEntry
extends DescribableEntry {
    public int getDimensions();

    @Nonnull
    public DescribableEntry getElementEntry();

    @Override
    default public boolean isAssignableFrom(@Nonnull DescribableEntry other) {
        if (other instanceof NullEntry) {
            return true;
        }
        if (other instanceof ArrayEntry) {
            ArrayEntry otherArray = (ArrayEntry)other;
            return this.isAssignableFrom(otherArray);
        }
        return false;
    }

    default public boolean isAssignableFrom(@Nonnull ArrayEntry other) {
        return this.getDimensions() == other.getDimensions() && this.getElementEntry().isAssignableFrom(other.getElementEntry());
    }

    @Override
    @Nonnull
    default public ArrayEntry toArrayEntry(int dimensions) {
        return new BasicArrayEntry(dimensions, this.getElementEntry());
    }
}

