/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.coley.sourcesolver.resolve.entry.BasicClassEntry;
import software.coley.sourcesolver.resolve.entry.BasicFieldEntry;
import software.coley.sourcesolver.resolve.entry.BasicMethodEntry;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;

public class ReflectiveClassEntry
extends BasicClassEntry {
    private ReflectiveClassEntry(@Nonnull String className, int access, @Nullable ClassEntry superEntry, @Nonnull List<ClassEntry> interfaceEntries, @Nonnull List<ClassEntry> innerClassEntries, @Nonnull List<FieldEntry> fields, @Nonnull List<MethodEntry> methods) {
        super(className, access, superEntry, interfaceEntries, innerClassEntries, fields, methods);
    }

    @Nonnull
    public static ClassEntry build(@Nonnull Map<String, ClassEntry> cache, @Nonnull Class<?> cls) {
        int modifiers;
        String className = cls.getName().replace('.', '/');
        ClassEntry cached = cache.get(className);
        if (cached != null) {
            return cached;
        }
        ArrayList<FieldEntry> fields = new ArrayList<FieldEntry>();
        ArrayList<MethodEntry> methods = new ArrayList<MethodEntry>();
        for (Field field : cls.getDeclaredFields()) {
            String fieldName = field.getName();
            String fieldDescriptor = field.getType().descriptorString();
            modifiers = field.getModifiers();
            fields.add(new BasicFieldEntry(fieldName, fieldDescriptor, modifiers));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredConstructors()) {
            String methodDescriptor = MethodType.methodType(Void.TYPE, ((Constructor)accessibleObject).getParameterTypes()).descriptorString();
            int modifiers2 = ((Constructor)accessibleObject).getModifiers();
            methods.add(new BasicMethodEntry("<init>", methodDescriptor, modifiers2));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            Class<?>[] methodName = ((Method)accessibleObject).getName();
            String methodDescriptor = MethodType.methodType(((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getParameterTypes()).descriptorString();
            modifiers = ((Method)accessibleObject).getModifiers();
            methods.add(new BasicMethodEntry((String)methodName, methodDescriptor, modifiers));
        }
        Class<?> superClass = cls.getSuperclass();
        Class<?>[] interfaces = cls.getInterfaces();
        ClassEntry superEntry = superClass == null ? null : ReflectiveClassEntry.build(cache, superClass);
        ArrayList<ClassEntry> arrayList = new ArrayList<ClassEntry>(interfaces.length);
        for (Class<?> implemented : interfaces) {
            arrayList.add(ReflectiveClassEntry.build(cache, implemented));
        }
        Class<?>[] innerClasses = cls.getDeclaredClasses();
        ArrayList<ClassEntry> innerClassEntries = new ArrayList<ClassEntry>();
        modifiers = cls.getModifiers();
        BasicClassEntry entry = new BasicClassEntry(className, modifiers, superEntry, arrayList, innerClassEntries, fields, methods);
        cache.put(className, entry);
        for (Class<?> innerClass : innerClasses) {
            if (!innerClass.getName().startsWith(cls.getName() + "$") || innerClass.getName().equals(cls.getName())) continue;
            innerClassEntries.add(ReflectiveClassEntry.build(cache, innerClass));
        }
        return entry;
    }
}

