/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.result;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.coley.sourcesolver.resolve.entry.ArrayEntry;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.ClassMemberPair;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;
import software.coley.sourcesolver.resolve.entry.EntryPool;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MemberEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;
import software.coley.sourcesolver.resolve.entry.NullEntry;
import software.coley.sourcesolver.resolve.entry.PrimitiveEntry;
import software.coley.sourcesolver.resolve.result.ArrayResolution;
import software.coley.sourcesolver.resolve.result.ClassResolution;
import software.coley.sourcesolver.resolve.result.DescribableResolution;
import software.coley.sourcesolver.resolve.result.FieldResolution;
import software.coley.sourcesolver.resolve.result.MethodResolution;
import software.coley.sourcesolver.resolve.result.MultiClassResolution;
import software.coley.sourcesolver.resolve.result.MultiMemberResolution;
import software.coley.sourcesolver.resolve.result.NullResolution;
import software.coley.sourcesolver.resolve.result.PackageResolution;
import software.coley.sourcesolver.resolve.result.PrimitiveResolution;
import software.coley.sourcesolver.resolve.result.Resolution;
import software.coley.sourcesolver.resolve.result.ThrowingResolution;
import software.coley.sourcesolver.resolve.result.UnknownResolution;

public class Resolutions {
    private static final UnknownResolution UNKNOWN_RESOLUTION = new UnknownResolutionImpl();
    private static final ThrowingResolution THROWS_RESOLUTION = new ThrowingResolutionImpl();
    private static final NullResolution NULL_RESOLUTION = new NullResolutionImpl();

    private Resolutions() {
    }

    @Nonnull
    public static UnknownResolution unknown() {
        return UNKNOWN_RESOLUTION;
    }

    @Nonnull
    public static ThrowingResolution throwing() {
        return THROWS_RESOLUTION;
    }

    @Nonnull
    public static NullResolution nul() {
        return NULL_RESOLUTION;
    }

    @Nonnull
    public static Resolution ofDescribable(@Nonnull DescribableEntry describable) {
        DescribableEntry describableEntry = describable;
        Objects.requireNonNull(describableEntry);
        DescribableEntry describableEntry2 = describableEntry;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveEntry.class, ClassEntry.class, ArrayEntry.class, NullEntry.class, MemberEntry.class}, (Object)describableEntry2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PrimitiveEntry primitiveEntry = (PrimitiveEntry)describableEntry2;
                yield Resolutions.ofPrimitive(primitiveEntry);
            }
            case 1 -> {
                ClassEntry classEntry = (ClassEntry)describableEntry2;
                yield Resolutions.ofClass(classEntry);
            }
            case 2 -> {
                ArrayEntry arrayEntry = (ArrayEntry)describableEntry2;
                yield Resolutions.ofArray(arrayEntry);
            }
            case 3 -> {
                NullEntry ignored = (NullEntry)describableEntry2;
                yield Resolutions.nul();
            }
            case 4 -> {
                MemberEntry ignored = (MemberEntry)describableEntry2;
                yield Resolutions.unknown();
            }
        };
    }

    @Nonnull
    public static PrimitiveResolution ofPrimitive(@Nonnull String descriptor) {
        return Resolutions.ofPrimitive(PrimitiveEntry.getPrimitive(descriptor));
    }

    @Nonnull
    public static PrimitiveResolution ofPrimitive(@Nonnull PrimitiveEntry primitive) {
        return new PrimitiveResolutionImpl(primitive);
    }

    @Nonnull
    public static ArrayResolution ofArray(@Nonnull DescribableResolution elementType, int dimensions) {
        return new ArrayResolutionImpl(elementType.getDescribableEntry().toArrayEntry(dimensions));
    }

    @Nonnull
    public static ArrayResolution ofArray(@Nonnull ArrayEntry array) {
        return new ArrayResolutionImpl(array);
    }

    @Nonnull
    public static PackageResolution ofPackage(@Nullable String name) {
        return new PackageResolutionImpl(name);
    }

    @Nonnull
    public static Resolution ofClass(@Nonnull EntryPool pool, @Nonnull String name) {
        ClassEntry entry = pool.getClass(name);
        if (entry == null) {
            return Resolutions.unknown();
        }
        return Resolutions.ofClass(entry);
    }

    @Nonnull
    public static ClassResolution ofClass(@Nonnull ClassEntry entry) {
        return new ClassResolutionImpl(entry);
    }

    @Nonnull
    public static FieldResolution ofField(@Nonnull ClassEntry classEntry, @Nonnull FieldEntry fieldEntry) {
        return new FieldResolutionImpl(classEntry, fieldEntry);
    }

    @Nonnull
    public static Resolution ofField(@Nonnull ClassEntry classEntry, @Nonnull String fieldName, @Nonnull String fieldDescriptor) {
        Resolution resolution;
        FieldEntry methodEntry = classEntry.getDeclaredField(fieldName, fieldDescriptor);
        if (methodEntry != null) {
            return new FieldResolutionImpl(classEntry, methodEntry);
        }
        ClassEntry superEntry = classEntry.getSuperEntry();
        if (superEntry != null && (resolution = Resolutions.ofField(superEntry, fieldName, fieldDescriptor)) instanceof FieldResolution) {
            FieldResolution resolution2 = (FieldResolution)resolution;
            return resolution2;
        }
        for (ClassEntry implementedEntry : classEntry.getImplementedEntries()) {
            Resolution resolution3 = Resolutions.ofField(implementedEntry, fieldName, fieldDescriptor);
            if (!(resolution3 instanceof FieldResolution)) continue;
            FieldResolution resolution4 = (FieldResolution)resolution3;
            return resolution4;
        }
        return Resolutions.unknown();
    }

    @Nonnull
    public static MethodResolution ofMethod(@Nonnull ClassEntry classEntry, @Nonnull MethodEntry methodEntry) {
        return new MethodResolutionImpl(classEntry, methodEntry);
    }

    @Nonnull
    public static Resolution ofMethod(@Nonnull ClassEntry classEntry, @Nonnull String methodName, @Nonnull DescribableEntry returnType, @Nonnull List<? extends DescribableEntry> parameters) {
        String descriptor = "(" + parameters.stream().map(DescribableEntry::getDescriptor).collect(Collectors.joining()) + ")" + returnType.getDescriptor();
        return Resolutions.ofMethod(classEntry, methodName, descriptor);
    }

    @Nonnull
    public static Resolution ofMethod(@Nonnull ClassEntry classEntry, @Nonnull String methodName, @Nonnull String methodDescriptor) {
        Resolution resolution;
        MethodEntry methodEntry = classEntry.getDeclaredMethod(methodName, methodDescriptor);
        if (methodEntry != null) {
            return new MethodResolutionImpl(classEntry, methodEntry);
        }
        ClassEntry superEntry = classEntry.getSuperEntry();
        if (superEntry != null && (resolution = Resolutions.ofMethod(superEntry, methodName, methodDescriptor)) instanceof MethodResolution) {
            MethodResolution resolution2 = (MethodResolution)resolution;
            return resolution2;
        }
        for (ClassEntry implementedEntry : classEntry.getImplementedEntries()) {
            Resolution resolution3 = Resolutions.ofMethod(implementedEntry, methodName, methodDescriptor);
            if (!(resolution3 instanceof MethodResolution)) continue;
            MethodResolution resolution4 = (MethodResolution)resolution3;
            return resolution4;
        }
        return Resolutions.unknown();
    }

    @Nonnull
    public static Resolution ofClasses(@Nonnull List<ClassEntry> classEntries) {
        if (classEntries.isEmpty()) {
            return Resolutions.unknown();
        }
        return new MultiClassResolutionImpl(classEntries);
    }

    @Nonnull
    public static Resolution ofMembers(@Nonnull List<ClassMemberPair> memberEntries) {
        if (memberEntries.isEmpty()) {
            return Resolutions.unknown();
        }
        return new MultiMemberResolutionImpl(memberEntries);
    }

    @Nonnull
    public static Resolution ofMember(@Nonnull ClassMemberPair pair) {
        return Resolutions.ofMember(pair.ownerEntry(), pair.memberEntry());
    }

    @Nonnull
    public static Resolution ofMember(@Nonnull ClassEntry ownerEntry, @Nonnull MemberEntry memberEntry) {
        if (memberEntry instanceof FieldEntry) {
            FieldEntry fieldEntry = (FieldEntry)memberEntry;
            return Resolutions.ofField(ownerEntry, fieldEntry);
        }
        if (memberEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)memberEntry;
            return Resolutions.ofMethod(ownerEntry, methodEntry);
        }
        return Resolutions.unknown();
    }

    @Nonnull
    public static Resolution mergeWith(@Nonnull Resolution left, @Nonnull Resolution right) {
        return Resolutions.mergeWith(MergeOp.MERGE_TYPES, left, right);
    }

    @Nonnull
    public static Resolution mergeWith(@Nonnull MergeOp mergeOp, @Nonnull Resolution left, @Nonnull Resolution right) {
        if (mergeOp == MergeOp.ADDITION_OR_CONCAT) {
            Resolution merged = Resolutions.mergeWith(MergeOp.MERGE_TYPES, left, right);
            if (merged.isUnknown()) {
                ClassResolution rightClass;
                ClassResolution leftClass;
                if (left instanceof ClassResolution && (leftClass = (ClassResolution)left).getClassEntry().extendsOrImplementsName("java/lang/String")) {
                    return leftClass;
                }
                if (right instanceof ClassResolution && (rightClass = (ClassResolution)right).getClassEntry().extendsOrImplementsName("java/lang/String")) {
                    return rightClass;
                }
            }
            return merged;
        }
        if (left.isUnknown() || right.isUnknown()) {
            return Resolutions.unknown();
        }
        if (left instanceof PrimitiveResolution) {
            PrimitiveResolution primitiveFirst = (PrimitiveResolution)left;
            if (right instanceof PrimitiveResolution) {
                PrimitiveResolution primitiveSecond = (PrimitiveResolution)right;
                return primitiveFirst.getPrimitiveEntry().isAssignableFrom(primitiveSecond.getPrimitiveEntry()) ? primitiveFirst : primitiveSecond;
            }
        }
        if (left instanceof ClassResolution) {
            ClassResolution classFirst = (ClassResolution)left;
            if (right instanceof ClassResolution) {
                ClassResolution classSecond = (ClassResolution)right;
                return Resolutions.ofClass(classFirst.getClassEntry().getCommonParent(classSecond.getClassEntry()));
            }
        }
        if (left instanceof ArrayResolution) {
            ArrayResolution arrayFirst = (ArrayResolution)left;
            if (right instanceof ArrayResolution) {
                Resolution mergedElemenentResolution;
                ArrayResolution arraySecond = (ArrayResolution)right;
                if (arrayFirst.getDimensions() == arraySecond.getDimensions() && (mergedElemenentResolution = Resolutions.mergeWith(arrayFirst.getElementTypeResolution(), arraySecond.getElementTypeResolution())) instanceof DescribableResolution) {
                    DescribableResolution describableElementResolution = (DescribableResolution)mergedElemenentResolution;
                    return Resolutions.ofArray(describableElementResolution, arrayFirst.getDimensions());
                }
            }
        }
        return Resolutions.unknown();
    }

    private record PrimitiveResolutionImpl(@Nonnull PrimitiveEntry primitive) implements PrimitiveResolution
    {
        @Override
        @Nonnull
        public PrimitiveEntry getPrimitiveEntry() {
            return this.primitive;
        }
    }

    private record ArrayResolutionImpl(@Nonnull ArrayEntry array) implements ArrayResolution
    {
        @Override
        @Nonnull
        public ArrayEntry getArrayEntry() {
            return this.array;
        }

        @Override
        @Nonnull
        public DescribableResolution getElementTypeResolution() {
            DescribableEntry element = this.array.getElementEntry();
            if (element instanceof ClassEntry) {
                ClassEntry classElement = (ClassEntry)element;
                return Resolutions.ofClass(classElement);
            }
            if (element instanceof PrimitiveEntry) {
                PrimitiveEntry primitiveElement = (PrimitiveEntry)element;
                return Resolutions.ofPrimitive(primitiveElement);
            }
            throw new IllegalStateException("Unknown element type: " + element.getClass().getSimpleName());
        }
    }

    private record PackageResolutionImpl(@Nullable String name) implements PackageResolution
    {
        @Override
        @Nullable
        public String getPackageName() {
            return this.name;
        }
    }

    private record ClassResolutionImpl(@Nonnull ClassEntry entry) implements ClassResolution
    {
        @Override
        @Nonnull
        public ClassEntry getClassEntry() {
            return this.entry;
        }
    }

    private record FieldResolutionImpl(@Nonnull ClassEntry ownerEntry, @Nonnull FieldEntry fieldEntry) implements FieldResolution
    {
        @Override
        @Nonnull
        public ClassEntry getOwnerEntry() {
            return this.ownerEntry;
        }

        @Override
        @Nonnull
        public FieldEntry getFieldEntry() {
            return this.fieldEntry;
        }

        @Override
        @Nonnull
        public ClassResolution getOwnerResolution() {
            return Resolutions.ofClass(this.ownerEntry);
        }
    }

    private record MethodResolutionImpl(@Nonnull ClassEntry ownerEntry, @Nonnull MethodEntry methodEntry) implements MethodResolution
    {
        @Override
        @Nonnull
        public ClassEntry getOwnerEntry() {
            return this.ownerEntry;
        }

        @Override
        @Nonnull
        public MethodEntry getMethodEntry() {
            return this.methodEntry;
        }

        @Override
        @Nonnull
        public ClassResolution getOwnerResolution() {
            return Resolutions.ofClass(this.ownerEntry);
        }
    }

    private record MultiClassResolutionImpl(@Nonnull List<ClassEntry> entries) implements MultiClassResolution
    {
        @Override
        @Nonnull
        public List<ClassEntry> getClassEntries() {
            return this.entries;
        }
    }

    private record MultiMemberResolutionImpl(@Nonnull List<ClassMemberPair> memberEntries) implements MultiMemberResolution
    {
        @Override
        @Nonnull
        public List<ClassMemberPair> getMemberEntries() {
            return this.memberEntries;
        }
    }

    public static enum MergeOp {
        MERGE_TYPES,
        ADDITION_OR_CONCAT;

    }

    private record UnknownResolutionImpl() implements UnknownResolution
    {
    }

    private record ThrowingResolutionImpl() implements ThrowingResolution
    {
    }

    private record NullResolutionImpl() implements NullResolution
    {
    }
}

