/*
 * Decompiled with CFR 0.152.
 */
package software.coley.treemap;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javax.annotation.Nonnull;
import software.coley.treemap.content.TreeContent;
import software.coley.treemap.squaring.Rectangle;
import software.coley.treemap.squaring.Squarify;

public class TreeMapPane<T>
extends Pane {
    protected final MapProperty<T, Node> valueToNode = new SimpleMapProperty();
    protected final ListProperty<T> valueList = new SimpleListProperty(FXCollections.observableArrayList());
    protected final ObjectProperty<ToDoubleFunction<T>> sizeFunction;
    protected final ObjectProperty<Function<T, Node>> nodeFactory;

    public TreeMapPane(@Nonnull ToDoubleFunction<T> sizeFunction, @Nonnull Function<T, Node> nodeFactory) {
        this.sizeFunction = new SimpleObjectProperty(sizeFunction);
        this.nodeFactory = new SimpleObjectProperty(nodeFactory);
        ObjectBinding multiSourceBindings = Bindings.createObjectBinding(() -> this, (Observable[])this.getTreeMapProperties());
        this.setupChangeBindings(multiSourceBindings);
        this.setSnapToPixel(false);
    }

    @Nonnull
    public static <C extends TreeContent> TreeMapPane<C> forTreeContent() {
        return new TreeMapPane<TreeContent>(TreeContent::getValueWeight, TreeContent::getNode);
    }

    protected void setupChangeBindings(@Nonnull ObjectBinding<?> multiSourceBindings) {
        this.valueToNode.bind(multiSourceBindings.map(unused -> {
            Function valueFunction = (Function)this.nodeFactory.get();
            Function keyFunction = Function.identity();
            BinaryOperator mergeFunction = (a, b) -> {
                throw new IllegalStateException();
            };
            Map map = this.valueList.stream().collect(Collectors.toMap(keyFunction, valueFunction, mergeFunction, IdentityHashMap::new));
            return FXCollections.observableMap((Map)map);
        }));
        this.valueToNode.addListener(change -> {
            ObservableList children = this.getChildren();
            if (change.wasAdded()) {
                children.add((Object)((Node)change.getValueAdded()));
            }
            if (change.wasRemoved()) {
                children.remove(change.getValueRemoved());
            }
        });
    }

    @Nonnull
    protected Observable[] getTreeMapProperties() {
        return new Observable[]{this.sizeFunction, this.nodeFactory, this.valueList};
    }

    @Nonnull
    public ListProperty<T> valueListProperty() {
        return this.valueList;
    }

    @Nonnull
    public ObservableMap<T, Node> valueToNodeProperty() {
        return FXCollections.unmodifiableObservableMap(this.valueToNode);
    }

    @Nonnull
    public ObjectProperty<Function<T, Node>> nodeFactoryProperty() {
        return this.nodeFactory;
    }

    @Nonnull
    public ObjectProperty<ToDoubleFunction<T>> sizeFunctionProperty() {
        return this.sizeFunction;
    }

    @Nonnull
    protected List<Rectangle<T>> computeRectangles(double canvasX, double canvasY, double canvasWidth, double canvasHeight) {
        return new Squarify((List)this.valueListProperty().get(), (ToDoubleFunction)this.sizeFunctionProperty().get(), canvasX, canvasY, canvasWidth, canvasHeight).getRectangles();
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double canvasX = insets.getLeft();
        double canvasY = insets.getTop();
        double canvasWidth = this.getWidth() - canvasX - insets.getRight();
        double canvasHeight = this.getHeight() - canvasY - insets.getBottom();
        if (canvasWidth <= 0.0 || canvasHeight <= 0.0) {
            return;
        }
        List<Rectangle<T>> rectangles = this.computeRectangles(canvasX, canvasY, canvasWidth, canvasHeight);
        ObservableMap<T, Node> valueToNode = this.valueToNodeProperty();
        for (Rectangle<T> rectangle : rectangles) {
            T value = rectangle.data();
            Node node = (Node)valueToNode.get(value);
            if (node == null) {
                throw new IllegalStateException("Value " + value + " had no mapping to a node");
            }
            this.layoutChild(rectangle, node);
        }
    }

    protected void layoutChild(@Nonnull Rectangle<T> rectangle, @Nonnull Node node) {
        double x = rectangle.x();
        double y = rectangle.y();
        double w = rectangle.width();
        double h = rectangle.height();
        node.resize(w, h);
        TreeMapPane.positionInArea((Node)node, (double)x, (double)y, (double)w, (double)h, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (boolean)this.isSnapToPixel());
    }
}

