/*
 * Decompiled with CFR 0.152.
 */
package software.coley.treemap.content;

import javafx.beans.property.ListProperty;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;
import software.coley.treemap.TreeMapPane;
import software.coley.treemap.content.HierarchicalTreeContent;
import software.coley.treemap.content.TreeContent;

public class SimpleHierarchicalTreeContent
implements HierarchicalTreeContent {
    private final ListProperty<TreeContent> children;
    private final ObservableValue<Double> weight;
    private final ObservableValue<TreeMapPane<TreeContent>> node;

    public SimpleHierarchicalTreeContent(@Nonnull ListProperty<TreeContent> children) {
        this.children = children;
        this.weight = children.map(list -> list.stream().mapToDouble(TreeContent::getValueWeight).sum());
        TreeMapPane treeMapPane = TreeMapPane.forTreeContent();
        this.node = this.children().map(list -> {
            treeMapPane.valueListProperty().bindContent(list);
            return treeMapPane;
        });
    }

    @Override
    @Nonnull
    public ListProperty<TreeContent> children() {
        return this.children;
    }

    @Override
    public double getValueWeight() {
        return (Double)this.weight.getValue();
    }

    @Override
    @Nonnull
    public TreeMapPane<TreeContent> getNode() {
        return (TreeMapPane)((Object)this.node.getValue());
    }
}

