/*
 * Decompiled with CFR 0.152.
 */
package software.coley.treemap.squaring;

import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;

public class SizeInfo<T> {
    private final DoubleSupplier ratioProvider;
    private final double size;
    private double normalizedValue = -1.0;
    private final T value;

    public SizeInfo(@Nonnull T value, double size, @Nonnull DoubleSupplier occupiedSpaceRatio) {
        this.value = value;
        this.size = size;
        this.ratioProvider = occupiedSpaceRatio;
    }

    public void normalize() {
        if (this.normalizedValue < 0.0) {
            this.normalizedValue = this.size * this.ratioProvider.getAsDouble();
        }
    }

    public double getSize() {
        return this.size;
    }

    public double getNormalizedSize() {
        return this.normalizedValue;
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeInfo sizeInfo = (SizeInfo)o;
        if (Double.compare(sizeInfo.size, this.size) != 0) {
            return false;
        }
        return this.value.equals(sizeInfo.value);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.size);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

