/*
 * Decompiled with CFR 0.152.
 */
package software.coley.treemap.squaring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import software.coley.treemap.squaring.SizeInfo;

public class SizeInfoProcessor<T> {
    private final List<SizeInfo<T>> infos = new ArrayList<SizeInfo<T>>();
    private final double totalSize;
    private final double totalArea;

    public SizeInfoProcessor(@Nonnull List<T> values, @Nonnull ToDoubleFunction<T> sizeFunction, double width, double height) {
        for (T t : values) {
            this.infos.add(new SizeInfo<T>(t, sizeFunction.applyAsDouble(t), this::getOccupiedSpaceRatio));
        }
        this.infos.sort(Comparator.comparingDouble(SizeInfo::getSize));
        Collections.reverse(this.infos);
        this.totalSize = this.infos.stream().mapToDouble(SizeInfo::getSize).sum();
        this.totalArea = width * height;
        for (SizeInfo sizeInfo : this.infos) {
            sizeInfo.normalize();
        }
    }

    @Nonnull
    public List<SizeInfo<T>> getSizeInfos() {
        return this.infos;
    }

    private double getOccupiedSpaceRatio() {
        return this.totalArea / this.totalSize;
    }
}

