/*
 * Decompiled with CFR 0.152.
 */
package software.coley.treemap.squaring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.treemap.squaring.Rectangle;
import software.coley.treemap.squaring.SizeInfo;
import software.coley.treemap.squaring.SizeInfoProcessor;

public class Squarify<T> {
    private final List<Rectangle<T>> rectangles;

    public Squarify(@Nonnull List<T> values, @Nonnull ToDoubleFunction<T> sizeFunction, double x, double y, double width, double height) {
        SizeInfoProcessor<T> processor = new SizeInfoProcessor<T>(values, sizeFunction, width, height);
        this.rectangles = this.squarify(processor.getSizeInfos(), x, y, width, height);
    }

    @Nonnull
    private List<Rectangle<T>> squarify(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        int i;
        if (values.size() == 0) {
            return Collections.emptyList();
        }
        if (values.size() == 1) {
            SizeInfo<T> sizeInfo = values.get(0);
            return Collections.singletonList(this.makeRect(sizeInfo.getValue(), x, y, width, height));
        }
        for (i = 1; i < values.size() && this.worstRatio(values.subList(0, i), x, y, width, height) >= this.worstRatio(values.subList(0, i + 1), x, y, width, height); ++i) {
        }
        List<SizeInfo<T>> current = values.subList(0, i);
        List<SizeInfo<T>> remaining = values.subList(i, values.size());
        Rectangle<T> currentLeftover = this.remainingSpace(current, x, y, width, height);
        ArrayList<Rectangle<T>> rectangles = new ArrayList<Rectangle<T>>(values.size());
        rectangles.addAll(this.layout(current, x, y, width, height));
        rectangles.addAll(this.squarify(remaining, currentLeftover.x(), currentLeftover.y(), currentLeftover.width(), currentLeftover.height()));
        return rectangles;
    }

    @Nonnull
    public List<Rectangle<T>> getRectangles() {
        return this.rectangles;
    }

    private double sumNormalizedSizes(@Nonnull List<SizeInfo<T>> values) {
        double result = 0.0;
        for (SizeInfo<T> info : values) {
            result += info.getNormalizedSize();
        }
        return result;
    }

    @Nonnull
    private List<Rectangle<T>> layoutRow(@Nonnull List<SizeInfo<T>> values, double x, double y, double height) {
        double coveredArea = this.sumNormalizedSizes(values);
        double width = coveredArea / height;
        ArrayList<Rectangle<T>> rectangles = new ArrayList<Rectangle<T>>(values.size());
        for (SizeInfo<T> value : values) {
            rectangles.add(this.makeRect(value.getValue(), x, y, width, value.getNormalizedSize() / width));
            y += value.getNormalizedSize() / width;
        }
        return rectangles;
    }

    @Nonnull
    private List<Rectangle<T>> layoutColumn(@Nonnull List<SizeInfo<T>> values, double x, double y, double width) {
        double coveredArea = this.sumNormalizedSizes(values);
        double height = coveredArea / width;
        ArrayList<Rectangle<T>> rectangles = new ArrayList<Rectangle<T>>(values.size());
        for (SizeInfo<T> value : values) {
            rectangles.add(this.makeRect(value.getValue(), x, y, value.getNormalizedSize() / height, height));
            x += value.getNormalizedSize() / height;
        }
        return rectangles;
    }

    @Nonnull
    private Rectangle<T> remainingRowSpace(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        double coveredArea = this.sumNormalizedSizes(values);
        double coveredHeight = coveredArea / height;
        double leftoverX = x + coveredHeight;
        double leftoverY = y;
        double leftoverWidth = width - coveredHeight;
        double leftoverHeight = height;
        return this.makeRect(null, leftoverX, leftoverY, leftoverWidth, leftoverHeight);
    }

    @Nonnull
    private Rectangle<T> remainingColumnSpace(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        double coveredArea = this.sumNormalizedSizes(values);
        double coveredWidth = coveredArea / width;
        double leftoverX = x;
        double leftoverY = y + coveredWidth;
        double leftoverWidth = width;
        double leftoverHeight = height - coveredWidth;
        return this.makeRect(null, leftoverX, leftoverY, leftoverWidth, leftoverHeight);
    }

    @Nonnull
    private Rectangle<T> remainingSpace(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        if (width >= height) {
            return this.remainingRowSpace(values, x, y, width, height);
        }
        return this.remainingColumnSpace(values, x, y, width, height);
    }

    @Nonnull
    private List<Rectangle<T>> layout(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        if (width >= height) {
            return this.layoutRow(values, x, y, height);
        }
        return this.layoutColumn(values, x, y, width);
    }

    @Nonnull
    protected Rectangle<T> makeRect(@Nullable T value, double x, double y, double width, double height) {
        return new Rectangle<T>(value, x, y, width, height);
    }

    private double worstRatio(@Nonnull List<SizeInfo<T>> values, double x, double y, double width, double height) {
        List<Rectangle<T>> rectangles = this.layout(values, x, y, width, height);
        double max = 0.0;
        for (Rectangle<T> rectangle : rectangles) {
            double rectWidth = rectangle.width();
            double rectHeight = rectangle.height();
            double maxValue = Math.max(rectWidth / rectHeight, rectHeight / rectWidth);
            max = Math.max(maxValue, max);
        }
        return max;
    }
}

