package software.constructs;

/**
 * (experimental) Trait for IDependable.
 * <p>
 * Traits are interfaces that are privately implemented by objects. Instead of
 * showing up in the public interface of a class, they need to be queried
 * explicitly. This is used to implement certain framework features that are
 * not intended to be used by Construct consumers, and so should be hidden
 * from accidental use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * // Usage
 * const roots = DependableTrait.get(construct).dependencyRoots;
 * // Definition
 * DependableTrait.implement(construct, {
 *   get dependencyRoots() { return []; }
 * });
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T07:12:37.676Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.constructs.$Module.class, fqn = "constructs.Dependable")
public abstract class Dependable extends software.amazon.jsii.JsiiObject {

    protected Dependable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dependable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Dependable() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (deprecated) Return the matching Dependable for the given class instance.
     * <p>
     * @deprecated use `of`
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.constructs.Dependable get(final @org.jetbrains.annotations.NotNull software.constructs.IDependable instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.constructs.Dependable.class, "get", software.amazon.jsii.NativeType.forClass(software.constructs.Dependable.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * (experimental) Turn any object into an IDependable.
     * <p>
     * @param instance This parameter is required.
     * @param trait This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static void implement(final @org.jetbrains.annotations.NotNull software.constructs.IDependable instance, final @org.jetbrains.annotations.NotNull software.constructs.Dependable trait) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.constructs.Dependable.class, "implement", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(instance, "instance is required"), java.util.Objects.requireNonNull(trait, "trait is required") });
    }

    /**
     * (experimental) Return the matching Dependable for the given class instance.
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.constructs.Dependable of(final @org.jetbrains.annotations.NotNull software.constructs.IDependable instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.constructs.Dependable.class, "of", software.amazon.jsii.NativeType.forClass(software.constructs.Dependable.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * (experimental) The set of constructs that form the root of this dependable.
     * <p>
     * All resources under all returned constructs are included in the ordering
     * dependency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.constructs.IConstruct> getDependencyRoots();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.constructs.Dependable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The set of constructs that form the root of this dependable.
         * <p>
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.constructs.IConstruct> getDependencyRoots() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencyRoots", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.IConstruct.class))));
        }
    }
}
