package software.constructs;

/**
 * Represents the building block of the construct graph.
 * <p>
 * All constructs besides the root construct must be created within the scope of
 * another construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.70.0 (build 03c2f6f)", date = "2022-10-22T00:12:17.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.constructs.$Module.class, fqn = "constructs.Construct")
public class Construct extends software.amazon.jsii.JsiiObject implements software.constructs.IConstruct {

    protected Construct(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Construct(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new construct node.
     * <p>
     * @param scope The scope in which to define this construct. This parameter is required.
     * @param id The scoped construct ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Construct(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Checks if `x` is a construct.
     * <p>
     * Use this method instead of <code>instanceof</code> to properly detect <code>Construct</code>
     * instances, even when the construct library is symlinked.
     * <p>
     * Explanation: in JavaScript, multiple copies of the <code>constructs</code> library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class <code>Construct</code> in each copy of the <code>constructs</code> library
     * is seen as a different class, and an instance of one class will not test as
     * <code>instanceof</code> the other class. <code>npm install</code> will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the <code>constructs</code>
     * library can be accidentally installed, and <code>instanceof</code> will behave
     * unpredictably. It is safest to avoid using <code>instanceof</code>, and using
     * this type-testing method instead.
     * <p>
     * @return true if `x` is an object created from a class which extends `Construct`.
     * @param x Any object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isConstruct(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.constructs.Construct.class, "isConstruct", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Returns a string representation of this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tree node.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
        return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
    }
}
