/**
 * <h1>Constructs</h1>
 * <p>
 * <blockquote>
 * <p>
 * Software-defined persistent state
 * <p>
 * </blockquote>
 * <p>
 * <img alt="Release" src="https://github.com/aws/constructs/workflows/Release/badge.svg">
 * <a href="https://badge.fury.io/js/constructs"><img alt="npm version" src="https://badge.fury.io/js/constructs.svg"></a>
 * <a href="https://badge.fury.io/py/constructs"><img alt="PyPI version" src="https://badge.fury.io/py/constructs.svg"></a>
 * <a href="https://badge.fury.io/nu/Constructs"><img alt="NuGet version" src="https://badge.fury.io/nu/Constructs.svg"></a>
 * <a href="https://maven-badges.herokuapp.com/maven-central/software.constructs/constructs"><img alt="Maven Central" src="https://maven-badges.herokuapp.com/maven-central/software.constructs/constructs/badge.svg?style=plastic"></a>
 * <p>
 * <h2>What are constructs?</h2>
 * <p>
 * Constructs are classes which define a "piece of system state". Constructs can be composed together to form higher-level building blocks which represent more complex state.
 * <p>
 * Constructs are often used to represent the <em>desired state</em> of cloud applications. For example, in the AWS CDK, which is used to define the desired state for AWS infrastructure using CloudFormation, the lowest-level construct represents a <em>resource definition</em> in a CloudFormation template. These resources are composed to represent higher-level logical units of a cloud application, etc.
 * <p>
 * <h2>Contributing</h2>
 * <p>
 * This project has adopted the <a href="https://aws.github.io/code-of-conduct">Amazon Open Source Code of
 * Conduct</a>.
 * <p>
 * We welcome community contributions and pull requests. See our <a href="./CONTRIBUTING.md">contribution
 * guide</a> for more information on how to report issues, set up a
 * development environment and submit code.
 * <p>
 * <h2>License</h2>
 * <p>
 * This project is distributed under the <a href="./LICENSE">Apache License, Version 2.0</a>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.constructs;
