/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.springframework.security.core.GrantedAuthority;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;

public class OwncloudModificationUser {
    private final String username;
    private String password;
    private boolean enabled = true;
    private String displayname;
    private String email;
    private Long quota;
    private List<String> groups = new ArrayList<String>();

    private OwncloudModificationUser(String username, String password, boolean enabled, String displayname, String email, Long quota, List<String> groups) {
        this.username = username;
        this.setPassword(password);
        this.setEnabled(enabled);
        this.setDisplayname(displayname);
        this.setEmail(email);
        this.setQuota(quota);
        this.groups.addAll(groups);
    }

    public static OwncloudModificationUser of(OwncloudUserDetails userDetails) {
        Validate.notNull((Object)userDetails);
        OwncloudModificationUser modificationUser = OwncloudModificationUser.builder().username(userDetails.getUsername()).password(userDetails.getPassword()).enabled(userDetails.isEnabled()).displayname(userDetails.getDisplayname()).email(userDetails.getEmail()).quota(userDetails.getQuota()).build();
        Optional.of(userDetails).map(OwncloudUserDetails::getAuthorities).orElseGet(ArrayList::new).stream().map(GrantedAuthority::getAuthority).forEach(modificationUser.groups::add);
        return modificationUser;
    }

    public void addGroup(String group) {
        Optional.ofNullable(group).ifPresent(this.groups::add);
    }

    public void removeGroup(String group) {
        Optional.of(group).ifPresent(this.groups::remove);
    }

    public static OwncloudModificationUserBuilder builder() {
        return new OwncloudModificationUserBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getEmail() {
        return this.email;
    }

    public Long getQuota() {
        return this.quota;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwncloudModificationUser)) {
            return false;
        }
        OwncloudModificationUser other = (OwncloudModificationUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$displayname = this.getDisplayname();
        String other$displayname = other.getDisplayname();
        if (this$displayname == null ? other$displayname != null : !this$displayname.equals(other$displayname)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Long this$quota = this.getQuota();
        Long other$quota = other.getQuota();
        if (this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota)) {
            return false;
        }
        List<String> this$groups = this.getGroups();
        List<String> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwncloudModificationUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $displayname = this.getDisplayname();
        result = result * 59 + ($displayname == null ? 43 : $displayname.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Long $quota = this.getQuota();
        result = result * 59 + ($quota == null ? 43 : ((Object)$quota).hashCode());
        List<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "OwncloudModificationUser(username=" + this.getUsername() + ", password=" + this.getPassword() + ", enabled=" + this.isEnabled() + ", displayname=" + this.getDisplayname() + ", email=" + this.getEmail() + ", quota=" + this.getQuota() + ", groups=" + this.getGroups() + ")";
    }

    public OwncloudModificationUser(String username) {
        this.username = username;
    }

    public static class OwncloudModificationUserBuilder {
        private String username;
        private String password;
        private boolean enabled;
        private String displayname;
        private String email;
        private Long quota;
        private ArrayList<String> groups;

        OwncloudModificationUserBuilder() {
        }

        public OwncloudModificationUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OwncloudModificationUserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OwncloudModificationUserBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OwncloudModificationUserBuilder displayname(String displayname) {
            this.displayname = displayname;
            return this;
        }

        public OwncloudModificationUserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public OwncloudModificationUserBuilder quota(Long quota) {
            this.quota = quota;
            return this;
        }

        public OwncloudModificationUserBuilder group(String group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return this;
        }

        public OwncloudModificationUserBuilder groups(Collection<? extends String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups cannot be null");
            }
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return this;
        }

        public OwncloudModificationUserBuilder clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return this;
        }

        public OwncloudModificationUser build() {
            List<Object> groups;
            switch (this.groups == null ? 0 : this.groups.size()) {
                case 0: {
                    groups = Collections.emptyList();
                    break;
                }
                case 1: {
                    groups = Collections.singletonList(this.groups.get(0));
                    break;
                }
                default: {
                    groups = Collections.unmodifiableList(new ArrayList<String>(this.groups));
                }
            }
            return new OwncloudModificationUser(this.username, this.password, this.enabled, this.displayname, this.email, this.quota, groups);
        }

        public String toString() {
            return "OwncloudModificationUser.OwncloudModificationUserBuilder(username=" + this.username + ", password=" + this.password + ", enabled=" + this.enabled + ", displayname=" + this.displayname + ", email=" + this.email + ", quota=" + this.quota + ", groups=" + this.groups + ")";
        }
    }
}

