/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.model;

import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class OwncloudUserDetails
implements UserDetails {
    private static final long serialVersionUID = 7384295040126418671L;
    @NotNull
    private String username;
    private char[] password;
    private boolean enabled = true;
    private Collection<? extends GrantedAuthority> authorities;
    private String displayname;
    private String email;
    private Long quota;

    public OwncloudUserDetails(String username, String password, boolean enabled, Collection<? extends GrantedAuthority> authorities, String displayname, String email, Long quota) {
        this.username = username;
        this.setPassword(password);
        this.enabled = enabled;
        this.authorities = authorities;
        this.displayname = displayname;
        this.email = email;
        this.quota = quota;
    }

    public String getPassword() {
        if (ArrayUtils.isEmpty((char[])this.password)) {
            return null;
        }
        return new String(this.password);
    }

    public void setPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            this.password = null;
            return;
        }
        this.password = password.toCharArray();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public static OwncloudUserDetailsBuilder builder() {
        return new OwncloudUserDetailsBuilder();
    }

    public OwncloudUserDetails() {
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getEmail() {
        return this.email;
    }

    public Long getQuota() {
        return this.quota;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwncloudUserDetails)) {
            return false;
        }
        OwncloudUserDetails other = (OwncloudUserDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwncloudUserDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "OwncloudUserDetails(username=" + this.getUsername() + ", enabled=" + this.isEnabled() + ", authorities=" + this.getAuthorities() + ", displayname=" + this.getDisplayname() + ", email=" + this.getEmail() + ", quota=" + this.getQuota() + ")";
    }

    public static class OwncloudUserDetailsBuilder {
        private String username;
        private String password;
        private boolean enabled;
        private Collection<? extends GrantedAuthority> authorities;
        private String displayname;
        private String email;
        private Long quota;

        OwncloudUserDetailsBuilder() {
        }

        public OwncloudUserDetailsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OwncloudUserDetailsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OwncloudUserDetailsBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OwncloudUserDetailsBuilder authorities(Collection<? extends GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public OwncloudUserDetailsBuilder displayname(String displayname) {
            this.displayname = displayname;
            return this;
        }

        public OwncloudUserDetailsBuilder email(String email) {
            this.email = email;
            return this;
        }

        public OwncloudUserDetailsBuilder quota(Long quota) {
            this.quota = quota;
            return this;
        }

        public OwncloudUserDetails build() {
            return new OwncloudUserDetails(this.username, this.password, this.enabled, this.authorities, this.displayname, this.email, this.quota);
        }

        public String toString() {
            return "OwncloudUserDetails.OwncloudUserDetailsBuilder(username=" + this.username + ", password=" + this.password + ", enabled=" + this.enabled + ", authorities=" + this.authorities + ", displayname=" + this.displayname + ", email=" + this.email + ", quota=" + this.quota + ")";
        }
    }
}

