/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.security.core.Authentication;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudResourcePipeSynchronizationException;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;

public abstract class AbstractPipedStreamSynchronizerImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractPipedStreamSynchronizerImpl.class);
    protected static final int EOF = -1;
    private final Authentication authentication;
    private final OwncloudProperties owncloudProperties;
    private final URI uri;
    private Thread thread;
    private boolean interrupted;
    private final CyclicBarrier pipeSync = new CyclicBarrier(2);

    protected AbstractPipedStreamSynchronizerImpl(Authentication authentication, OwncloudProperties owncloudProperties, URI uri) {
        this.authentication = authentication;
        this.owncloudProperties = owncloudProperties;
        this.uri = uri;
    }

    protected void finalize() throws Throwable {
        if (this.thread != null && this.thread.isAlive()) {
            log.debug("Stop Thread {}", (Object)this.thread.getName());
            this.interrupt(this.thread);
            this.thread.join();
        }
    }

    private void interrupt(Thread thread) {
        this.interrupted = true;
        thread.interrupt();
    }

    protected void setPipeReady() {
        try {
            log.debug("Release the Cyclic Barrier for the synchronized piped Stream of Thread {}", (Object)Thread.currentThread());
            this.pipeSync.await();
        }
        catch (Exception e) {
            String logMessage = String.format("Error while waiting for the PipedStream-Barrier by Thread %s", Thread.currentThread());
            log.error(logMessage, (Throwable)e);
            throw new OwncloudResourcePipeSynchronizationException(logMessage, e);
        }
    }

    protected final void startThreadAndWaitForConnectedPipe() {
        if (this.isThreadExistsAndIsAlive()) {
            return;
        }
        this.startBackgroundThread();
        this.waitForPipeReady();
    }

    private boolean isThreadExistsAndIsAlive() {
        return this.thread != null && this.thread.isAlive();
    }

    private void startBackgroundThread() {
        this.interrupted = false;
        this.thread = new Thread(this::createPipedStream);
        this.thread.setName(this.getThreadName());
        this.thread.setUncaughtExceptionHandler(this::handleUncaughtException);
        log.debug("Start the Background Thread {}", (Object)this.thread.getName());
        this.thread.start();
    }

    protected abstract void createPipedStream();

    protected abstract String getThreadName();

    private void handleUncaughtException(Thread thread, Throwable cause) {
        LogLevel logLevel = this.getUncaughtExceptionLogLevel();
        if (logLevel == LogLevel.OFF) {
            return;
        }
        String logMessage = String.format("Error while executing %s", thread);
        switch (logLevel) {
            case TRACE: {
                log.trace(logMessage, cause);
                break;
            }
            case DEBUG: {
                log.debug(logMessage, cause);
                break;
            }
            case INFO: {
                log.info(logMessage, cause);
                break;
            }
            case WARN: {
                log.warn(logMessage, cause);
                break;
            }
            default: {
                log.error(logMessage, cause);
            }
        }
    }

    private LogLevel getUncaughtExceptionLogLevel() {
        OwncloudProperties.ResourceServiceProperties resourceProperties = this.owncloudProperties.getResourceService();
        return resourceProperties.getPipedStreamUncaughtExceptionLogLevel();
    }

    protected void waitForPipeReady() {
        try {
            log.debug("Thread {} waits for the Background Thread of the synchronized piped Stream", (Object)Thread.currentThread());
            this.pipeSync.await();
        }
        catch (Exception e) {
            log.error("Error while waiting for PipedStream-Barrier", (Throwable)e);
            throw new OwncloudResourcePipeSynchronizationException(e);
        }
    }

    protected String getUsername() {
        return this.authentication.getName();
    }

    protected URI getUri() {
        return this.uri;
    }

    protected long copy(InputStream input, OutputStream output) throws IOException {
        long contentLength = 0L;
        int bufferSize = this.getBufferSize();
        log.debug("Copy Content with a Buffersize of {} Bytes", (Object)bufferSize);
        byte[] buffer = new byte[bufferSize];
        int length = 0;
        while ((length = input.read(buffer)) != -1) {
            output.write(buffer, 0, length);
            contentLength += (long)length;
            if (!this.isInterrupted()) continue;
            log.warn("Background Thread has been interrupted -> stop the Copy Process");
            return contentLength;
        }
        return contentLength;
    }

    protected int getBufferSize() {
        return Optional.ofNullable(this.owncloudProperties).map(this::extractBufferSize).orElse(8192);
    }

    private int extractBufferSize(OwncloudProperties properties) {
        OwncloudProperties.ResourceServiceProperties resourceProperties = properties.getResourceService();
        return resourceProperties.getPipedStreamBufferSize();
    }

    protected Authentication getAuthentication() {
        return this.authentication;
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }
}

