/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudInvalidAuthenticationObjectException;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUtils;

@Aspect
public class OwncloudAuthenticationTypeChecker {
    private static final Logger log = LoggerFactory.getLogger(OwncloudAuthenticationTypeChecker.class);
    private final OwncloudProperties owncloudProperties;

    @Before(value="execution(* software.coolstuff.springframework.owncloud.service.api..*.*(..)) && @annotation(software.coolstuff.springframework.owncloud.service.impl.CheckOwncloudModification)")
    void checkModificationsAllowed(JoinPoint joinPoint) {
        if (this.modificationsNotAllowed()) {
            log.warn("Access denied for Method {}.{}() because Modifications are not allowed", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
            throw new AccessDeniedException("no modifications allowed");
        }
    }

    private boolean modificationsNotAllowed() {
        return this.owncloudProperties.getUserService() == null || !this.owncloudProperties.getUserService().isEnableModifications();
    }

    @Before(value="execution(* software.coolstuff.springframework.owncloud.service.api.OwncloudUserService.*(..)) || execution(* software.coolstuff.springframework.owncloud.service.api.OwncloudGroupService.*(..)) || execution(* software.coolstuff.springframework.owncloud.service.api.OwncloudResourceService.*(..)) || execution(* software.coolstuff.springframework.owncloud.service.impl.OwncloudUserDetailsService.*(..))")
    void checkAuthenticationObject(JoinPoint joinPoint) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (OwncloudUtils.isInvalidAuthentication(authentication)) {
            log.warn("Access denied for Method {}.{}(); because User is not authenticated by the Owncloud Authentication Provider", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
            throw new OwncloudInvalidAuthenticationObjectException(authentication, UsernamePasswordAuthenticationToken.class);
        }
    }

    public OwncloudAuthenticationTypeChecker(OwncloudProperties owncloudProperties) {
        this.owncloudProperties = owncloudProperties;
    }
}

