/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGrantedAuthoritiesMapper;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudAuthenticationTypeChecker;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;

@Configuration
@ConditionalOnProperty(prefix="owncloud", name={"location"})
@EnableAspectJAutoProxy
public class OwncloudAutoConfiguration {
    private final OwncloudProperties owncloudProperties;

    @Bean
    public OwncloudAuthenticationTypeChecker owncloudUserModificationChecker() {
        return new OwncloudAuthenticationTypeChecker(this.owncloudProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={OwncloudGrantedAuthoritiesMappingService.class})
    public OwncloudGrantedAuthoritiesMappingService owncloudUserDetailsMappingService(@Autowired(required=false) OwncloudGrantedAuthoritiesMapper owncloudGrantedAuthoritiesMapper, @Autowired(required=false) GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        return new OwncloudGrantedAuthoritiesMappingServiceImpl(owncloudGrantedAuthoritiesMapper, grantedAuthoritiesMapper);
    }

    public OwncloudAutoConfiguration(OwncloudProperties owncloudProperties) {
        this.owncloudProperties = owncloudProperties;
    }
}

