/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGrantedAuthoritiesMapper;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;

public class OwncloudGrantedAuthoritiesMappingServiceImpl
implements OwncloudGrantedAuthoritiesMappingService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudGrantedAuthoritiesMappingServiceImpl.class);
    private final OwncloudGrantedAuthoritiesMapper owncloudGrantedAuthoritiesMapper;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    @Override
    public Collection<? extends GrantedAuthority> mapGrantedAuthorities(OwncloudUserDetails userDetails) {
        if (this.owncloudGrantedAuthoritiesMapper != null) {
            log.debug("Map the Authorities of User {} by {} ({})", new Object[]{userDetails.getUsername(), OwncloudGrantedAuthoritiesMapper.class, this.owncloudGrantedAuthoritiesMapper.getClass()});
            return this.owncloudGrantedAuthoritiesMapper.mapAuthorities(userDetails.getUsername(), userDetails.getAuthorities());
        }
        if (this.grantedAuthoritiesMapper != null) {
            log.debug("Map the Authorities of User {} by {} ({})", new Object[]{userDetails.getUsername(), GrantedAuthoritiesMapper.class, this.grantedAuthoritiesMapper.getClass()});
            return this.grantedAuthoritiesMapper.mapAuthorities(userDetails.getAuthorities());
        }
        log.debug("Return unmodified granted Authorities of User {}", (Object)userDetails.getUsername());
        return userDetails.getAuthorities();
    }

    public OwncloudGrantedAuthoritiesMappingServiceImpl(OwncloudGrantedAuthoritiesMapper owncloudGrantedAuthoritiesMapper, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        this.owncloudGrantedAuthoritiesMapper = owncloudGrantedAuthoritiesMapper;
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
    }
}

