/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.boot.logging.LogLevel;
import org.springframework.validation.annotation.Validated;

@Validated
public abstract class OwncloudProperties {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private String location;
    private UserService userService = new UserService();
    private ResourceServiceProperties resourceService = new ResourceServiceProperties();

    public String getLocation() {
        return this.location;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public ResourceServiceProperties getResourceService() {
        return this.resourceService;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setResourceService(ResourceServiceProperties resourceService) {
        this.resourceService = resourceService;
    }

    @Validated
    public static class ResourceServiceProperties {
        private boolean addRelativeDownPath = true;
        @Min(value=1L)
        private @Min(value=1L) int pipedStreamBufferSize = 8192;
        @NotNull
        private LogLevel pipedStreamUncaughtExceptionLogLevel = LogLevel.ERROR;

        public boolean isAddRelativeDownPath() {
            return this.addRelativeDownPath;
        }

        public int getPipedStreamBufferSize() {
            return this.pipedStreamBufferSize;
        }

        public LogLevel getPipedStreamUncaughtExceptionLogLevel() {
            return this.pipedStreamUncaughtExceptionLogLevel;
        }

        public void setAddRelativeDownPath(boolean addRelativeDownPath) {
            this.addRelativeDownPath = addRelativeDownPath;
        }

        public void setPipedStreamBufferSize(int pipedStreamBufferSize) {
            this.pipedStreamBufferSize = pipedStreamBufferSize;
        }

        public void setPipedStreamUncaughtExceptionLogLevel(LogLevel pipedStreamUncaughtExceptionLogLevel) {
            this.pipedStreamUncaughtExceptionLogLevel = pipedStreamUncaughtExceptionLogLevel;
        }
    }

    @Validated
    public static class UserService {
        private boolean enableModifications = true;

        public boolean isEnableModifications() {
            return this.enableModifications;
        }

        public void setEnableModifications(boolean enableModifications) {
            this.enableModifications = enableModifications;
        }
    }
}

