/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl;

import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudNoFileResourceException;
import software.coolstuff.springframework.owncloud.model.OwncloudFileResource;
import software.coolstuff.springframework.owncloud.model.OwncloudResource;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;

public final class OwncloudUtils {
    private static final String UNIX_DIRECTORY = "httpd/unix-directory";

    public static boolean isAuthenticationClassSupported(Class<?> authenticationClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authenticationClass);
    }

    public static boolean isAuthenticationClassNotSupported(Class<?> authenticationClass) {
        return !OwncloudUtils.isAuthenticationClassSupported(authenticationClass);
    }

    public static boolean isValidAuthentication(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        if (authentication.getDetails() != null && !ClassUtils.isAssignable(authentication.getPrincipal().getClass(), OwncloudUserDetails.class)) {
            return false;
        }
        if (authentication.getCredentials() != null) {
            return CharSequence.class.isAssignableFrom(authentication.getCredentials().getClass()) && StringUtils.isNotBlank((CharSequence)((CharSequence)authentication.getCredentials()));
        }
        if (authentication.getPrincipal() != null) {
            UserDetails userDetails = (UserDetails)authentication.getPrincipal();
            return StringUtils.isNotBlank((CharSequence)userDetails.getPassword());
        }
        return false;
    }

    public static boolean isInvalidAuthentication(Authentication authentication) {
        return !OwncloudUtils.isValidAuthentication(authentication);
    }

    public static OwncloudFileResource toOwncloudFileResource(OwncloudResource owncloudResource) throws OwncloudNoFileResourceException {
        if (owncloudResource == null) {
            return null;
        }
        if (OwncloudUtils.isDirectory(owncloudResource) || !ClassUtils.isAssignable(owncloudResource.getClass(), OwncloudFileResource.class)) {
            throw new OwncloudNoFileResourceException(owncloudResource.getHref());
        }
        return (OwncloudFileResource)owncloudResource;
    }

    public static boolean isDirectory(OwncloudResource owncloudResource) {
        return UNIX_DIRECTORY.equals(Optional.ofNullable(owncloudResource).map(resource -> resource.getMediaType().toString()).orElse(null));
    }

    public static boolean isNotDirectory(OwncloudResource owncloudResource) {
        return !OwncloudUtils.isDirectory(owncloudResource);
    }

    public static MediaType getDirectoryMediaType() {
        return MediaType.valueOf((String)UNIX_DIRECTORY);
    }

    private OwncloudUtils() {
    }
}

