/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUtils;

abstract class AbstractOwncloudLocalUserAndGroupServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractOwncloudLocalUserAndGroupServiceImpl.class);
    private final OwncloudLocalUserDataService localUserDataService;

    protected OwncloudLocalUserData.User getCheckedUser(String username) {
        Validate.notBlank((CharSequence)username);
        log.debug("Get User {} from Resource Service", (Object)username);
        OwncloudLocalUserData.User user = this.localUserDataService.getUser(username);
        OwncloudLocalUtils.validateUserNotNull(user, username);
        return user;
    }

    public AbstractOwncloudLocalUserAndGroupServiceImpl(OwncloudLocalUserDataService localUserDataService) {
        this.localUserDataService = localUserDataService;
    }

    public OwncloudLocalUserDataService getLocalUserDataService() {
        return this.localUserDataService;
    }
}

