/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUserDetailsService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUtils;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;

public class OwncloudLocalAuthenticationProviderImpl
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalAuthenticationProviderImpl.class);
    private MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private final OwncloudLocalUserDataService localDataService;
    private final OwncloudUserDetailsService userDetailsService;
    private final OwncloudGrantedAuthoritiesMappingService grantedAuthoritiesMappingService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String password;
        String username = authentication.getName();
        if (StringUtils.isBlank((CharSequence)username)) {
            log.error("Username is null or empty");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        String string = password = authentication.getCredentials() != null ? authentication.getCredentials().toString() : null;
        if (StringUtils.isBlank((CharSequence)password)) {
            log.error("Password is null or empty");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        log.debug("Get Information about User {} from the Resource Service", (Object)username);
        OwncloudLocalUserData.User user = this.localDataService.getUser(username);
        if (user == null) {
            log.error("User {} has not been found", (Object)username);
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        if (!user.isEnabled()) {
            log.error("User {} is disabled", (Object)username);
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "Disabled"));
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)user.getPassword())) {
            log.error("Wrong Password of User {}", (Object)username);
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        log.debug("Set a new UsernamePasswordAuthenticationToken with User {} to the SecurityContextHolder", (Object)username);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        log.info("User {} has been successfully authenticated. Get Information from UserDetailsService", (Object)username);
        OwncloudUserDetails owncloudUserDetails = (OwncloudUserDetails)this.userDetailsService.loadUserByUsername(username);
        log.trace("Set the Password of User {} to the Authentication Object", (Object)username);
        owncloudUserDetails.setPassword(password);
        return new UsernamePasswordAuthenticationToken((Object)owncloudUserDetails, (Object)password, this.grantedAuthoritiesMappingService.mapGrantedAuthorities(owncloudUserDetails));
    }

    public boolean supports(Class<?> authentication) {
        return OwncloudUtils.isAuthenticationClassSupported(authentication);
    }

    public OwncloudLocalAuthenticationProviderImpl(OwncloudLocalUserDataService localDataService, OwncloudUserDetailsService userDetailsService, OwncloudGrantedAuthoritiesMappingService grantedAuthoritiesMappingService) {
        this.localDataService = localDataService;
        this.userDetailsService = userDetailsService;
        this.grantedAuthoritiesMappingService = grantedAuthoritiesMappingService;
    }
}

