/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGroupService;
import software.coolstuff.springframework.owncloud.service.api.OwncloudResourceService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUserDetailsService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalAuthenticationProviderImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalGroupServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalProperties;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalResourceChecksumService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalResourceChecksumServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalResourceService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalResourceServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDetailsServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserServiceExtension;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserServiceImpl;

@Configuration
@ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
@ConditionalOnExpression(value="#{'${owncloud.location}' matches 'file:.*' or '${owncloud.location}' matches 'classpath:.*'}")
@EnableConfigurationProperties(value={OwncloudLocalProperties.class})
public class OwncloudLocalAutoConfiguration {
    private final Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder;
    private final ResourceLoader resourceLoader;
    private final OwncloudProperties owncloudProperties;
    private final OwncloudGrantedAuthoritiesMappingService owncloudGrantedAuthoritiesMappingService;

    @Bean
    public OwncloudLocalUserServiceExtension owncloudLocalUserService() {
        return new OwncloudLocalUserServiceImpl(this.owncloudLocalUserDataService());
    }

    @Bean
    public OwncloudGroupService owncloudGroupService() {
        return new OwncloudLocalGroupServiceImpl(this.owncloudLocalUserDataService());
    }

    @Bean
    @Qualifier(value="owncloudAuthenticationProvider")
    @ConditionalOnMissingBean(value={OwncloudLocalAuthenticationProviderImpl.class})
    public OwncloudLocalAuthenticationProviderImpl owncloudAuthenticationProvider() {
        return new OwncloudLocalAuthenticationProviderImpl(this.owncloudLocalUserDataService(), this.owncloudUserDetailsService(), this.owncloudGrantedAuthoritiesMappingService);
    }

    @Bean
    @Qualifier(value="owncloudUserDetailsService")
    @ConditionalOnMissingBean(value={OwncloudLocalUserDetailsServiceImpl.class})
    public OwncloudUserDetailsService owncloudUserDetailsService() {
        return new OwncloudLocalUserDetailsServiceImpl(this.owncloudLocalUserDataService());
    }

    @Bean
    @ConditionalOnMissingBean(value={OwncloudLocalUserDataService.class})
    public OwncloudLocalUserDataService owncloudLocalUserDataService() {
        return new OwncloudLocalUserDataServiceImpl(this.jackson2ObjectMapperBuilder, this.resourceLoader, this.owncloudProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={OwncloudLocalResourceChecksumService.class})
    @ConditionalOnProperty(value={"owncloud.resource-service.location"})
    public OwncloudLocalResourceChecksumService owncloudLocalResourceChecksumService() {
        return new OwncloudLocalResourceChecksumServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={OwncloudResourceService.class})
    @ConditionalOnProperty(value={"owncloud.resource-service.location"})
    public OwncloudLocalResourceService owncloudResourceService() {
        return new OwncloudLocalResourceServiceImpl();
    }

    public OwncloudLocalAutoConfiguration(Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder, ResourceLoader resourceLoader, OwncloudProperties owncloudProperties, OwncloudGrantedAuthoritiesMappingService owncloudGrantedAuthoritiesMappingService) {
        this.jackson2ObjectMapperBuilder = jackson2ObjectMapperBuilder;
        this.resourceLoader = resourceLoader;
        this.owncloudProperties = owncloudProperties;
        this.owncloudGrantedAuthoritiesMappingService = owncloudGrantedAuthoritiesMappingService;
    }
}

