/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupAlreadyExistsException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupNotFoundException;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGroupService;
import software.coolstuff.springframework.owncloud.service.impl.CheckOwncloudModification;
import software.coolstuff.springframework.owncloud.service.impl.local.AbstractOwncloudLocalUserAndGroupServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;

public class OwncloudLocalGroupServiceImpl
extends AbstractOwncloudLocalUserAndGroupServiceImpl
implements OwncloudGroupService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalGroupServiceImpl.class);

    public OwncloudLocalGroupServiceImpl(OwncloudLocalUserDataService localUserDataService) {
        super(localUserDataService);
    }

    @Override
    public List<String> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<String> findAll(String filter) {
        log.debug("Get all Users with a Group like {}", (Object)filter);
        ArrayList<String> filteredGroups = new ArrayList<String>();
        for (String group : this.getLocalUserDataService().getGroups()) {
            if (!StringUtils.isBlank((CharSequence)filter) && !StringUtils.contains((CharSequence)group, (CharSequence)filter)) continue;
            log.trace("add Group {} to the Result", (Object)group);
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    @Override
    public List<String> findAllUsers(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        if (this.getLocalUserDataService().groupNotExists(groupname)) {
            log.error("Group {} not found", (Object)groupname);
            throw new OwncloudGroupNotFoundException(groupname);
        }
        log.debug("Get all Members of Group {}", (Object)groupname);
        ArrayList<String> members = new ArrayList<String>();
        for (OwncloudLocalUserData.User user : this.getLocalUserDataService().getUsers()) {
            this.addWhenMemberOfGroup(groupname, members, user);
        }
        return members;
    }

    private void addWhenMemberOfGroup(String groupname, List<String> members, OwncloudLocalUserData.User user) {
        if (CollectionUtils.isNotEmpty(user.getGroups())) {
            for (String group : user.getGroups()) {
                if (!StringUtils.equals((CharSequence)groupname, (CharSequence)group)) continue;
                log.trace("Add User {} as a Member of Group {}", (Object)user.getUsername(), (Object)groupname);
                members.add(user.getUsername());
                break;
            }
        }
    }

    @Override
    public List<String> findAllGroups(String username) {
        OwncloudLocalUserData.User user = this.getCheckedUser(username);
        ArrayList<String> groups = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(user.getGroups())) {
            log.debug("Get all Groups assigned to User {}", (Object)user.getUsername());
            for (String group : user.getGroups()) {
                log.trace("Add Group {} to be assigned to User {}", (Object)group, (Object)user.getUsername());
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    @CheckOwncloudModification
    public void create(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        if (this.getLocalUserDataService().groupExists(groupname)) {
            log.error("Group {} already exists", (Object)groupname);
            throw new OwncloudGroupAlreadyExistsException(groupname);
        }
        log.debug("Create Group {}", (Object)groupname);
        this.getLocalUserDataService().addGroup(groupname);
        log.info("Group {} successfully created");
    }

    @Override
    @CheckOwncloudModification
    public void delete(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        log.debug("Get Information of Group {} from the Resource Service", (Object)groupname);
        String group = this.getLocalUserDataService().getGroup(groupname);
        if (StringUtils.isBlank((CharSequence)group)) {
            throw new OwncloudGroupNotFoundException(groupname);
        }
        for (OwncloudLocalUserData.User user : this.getLocalUserDataService().getUsers()) {
            if (user.getGroups() == null) continue;
            log.trace("Revoke Assignment of Group {} from User {}", (Object)groupname, (Object)user.getUsername());
            user.getGroups().remove(group);
        }
        log.debug("Remove Group {}", (Object)groupname);
        this.getLocalUserDataService().removeGroup(groupname);
        log.info("Group {} successfully removed", (Object)groupname);
    }
}

