/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;

@Validated
@ConfigurationProperties(value="owncloud")
public class OwncloudLocalProperties
extends OwncloudProperties {
    private ResourceServiceProperties resourceService = new ResourceServiceProperties();

    @Override
    public ResourceServiceProperties getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(ResourceServiceProperties resourceService) {
        this.resourceService = resourceService;
    }

    @Validated
    public static class ResourceServiceProperties
    extends OwncloudProperties.ResourceServiceProperties {
        @NotNull
        private MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.MD5;
        private Path location;
        @NotNull
        private String pipedStreamTemporaryFilePrefix = "owncloud";

        public MessageDigestAlgorithm getMessageDigestAlgorithm() {
            return this.messageDigestAlgorithm;
        }

        public Path getLocation() {
            return this.location;
        }

        public String getPipedStreamTemporaryFilePrefix() {
            return this.pipedStreamTemporaryFilePrefix;
        }

        public void setMessageDigestAlgorithm(MessageDigestAlgorithm messageDigestAlgorithm) {
            this.messageDigestAlgorithm = messageDigestAlgorithm;
        }

        public void setLocation(Path location) {
            this.location = location;
        }

        public void setPipedStreamTemporaryFilePrefix(String pipedStreamTemporaryFilePrefix) {
            this.pipedStreamTemporaryFilePrefix = pipedStreamTemporaryFilePrefix;
        }

        public static enum MessageDigestAlgorithm {
            MD5("MD5");

            private final String algorithm;

            public MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
                return MessageDigest.getInstance(this.algorithm);
            }

            private MessageDigestAlgorithm(String algorithm) {
                this.algorithm = algorithm;
            }
        }
    }
}

