/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudLocalResourceException;
import software.coolstuff.springframework.owncloud.model.OwncloudQuota;

class OwncloudLocalQuotaImpl
implements OwncloudQuota,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalQuotaImpl.class);
    private final String username;
    private final Path location;
    private Long total;
    private long used;

    @Override
    public long getTotal() {
        if (this.total == null) {
            return this.getFreeSpaceOfLocation();
        }
        if (this.used > this.total) {
            return this.used;
        }
        return this.total;
    }

    private long getFreeSpaceOfLocation() {
        try {
            return Files.getFileStore(this.location).getUsableSpace();
        }
        catch (IOException e) {
            String logMessage = "Error while getting the free Space of the Path " + this.location.toAbsolutePath().normalize().toString();
            log.error(logMessage);
            throw new OwncloudLocalResourceException(logMessage, e);
        }
    }

    public synchronized void increaseUsed(long size) {
        this.used += size;
    }

    public synchronized void reduceUsed(long size) {
        this.used -= size;
    }

    @Override
    public long getFree() {
        long free = this.getTotal() - this.used;
        return free > 0L ? free : 0L;
    }

    @Override
    public float getRelative() {
        return (float)this.used * 100.0f / (float)this.getTotal();
    }

    private static long $default$used() {
        return 0L;
    }

    OwncloudLocalQuotaImpl(String username, Path location, Long total, long used) {
        this.username = username;
        this.location = location;
        this.total = total;
        this.used = used;
    }

    public static OwncloudLocalQuotaImplBuilder builder() {
        return new OwncloudLocalQuotaImplBuilder();
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwncloudLocalQuotaImpl)) {
            return false;
        }
        OwncloudLocalQuotaImpl other = (OwncloudLocalQuotaImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Path this$location = this.location;
        Path other$location = other.location;
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        return this.getUsed() == other.getUsed();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwncloudLocalQuotaImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Path $location = this.location;
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $used = this.getUsed();
        result = result * 59 + (int)($used >>> 32 ^ $used);
        return result;
    }

    public String toString() {
        return "OwncloudLocalQuotaImpl(username=" + this.getUsername() + ", total=" + this.getTotal() + ", used=" + this.getUsed() + ")";
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public long getUsed() {
        return this.used;
    }

    public void setUsed(long used) {
        this.used = used;
    }

    public static class OwncloudLocalQuotaImplBuilder {
        private String username;
        private Path location;
        private Long total;
        private boolean used$set;
        private long used$value;

        OwncloudLocalQuotaImplBuilder() {
        }

        public OwncloudLocalQuotaImplBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OwncloudLocalQuotaImplBuilder location(Path location) {
            this.location = location;
            return this;
        }

        public OwncloudLocalQuotaImplBuilder total(Long total) {
            this.total = total;
            return this;
        }

        public OwncloudLocalQuotaImplBuilder used(long used) {
            this.used$value = used;
            this.used$set = true;
            return this;
        }

        public OwncloudLocalQuotaImpl build() {
            long used$value = this.used$value;
            if (!this.used$set) {
                used$value = OwncloudLocalQuotaImpl.$default$used();
            }
            return new OwncloudLocalQuotaImpl(this.username, this.location, this.total, used$value);
        }

        public String toString() {
            return "OwncloudLocalQuotaImpl.OwncloudLocalQuotaImplBuilder(username=" + this.username + ", location=" + this.location + ", total=" + this.total + ", used$value=" + this.used$value + ")";
        }
    }
}

