/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudLocalResourceChecksumServiceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudResourceException;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalProperties;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalResourceChecksumService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUtils;

public class OwncloudLocalResourceChecksumServiceImpl
implements OwncloudLocalResourceChecksumService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalResourceChecksumServiceImpl.class);
    @Autowired
    private OwncloudLocalProperties properties;
    private final Map<Path, String> checksums = new ConcurrentHashMap<Path, String>();
    private final InitializingFileVisitor fileVisitor = InitializingFileVisitor.builder().checksums(this.checksums).directoryDigest(this::createDirectoryChecksum).fileDigest(this::createFileChecksum).build();
    private MessageDigest messageDigest;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        OwncloudLocalProperties.ResourceServiceProperties resourceProperties = this.properties.getResourceService();
        OwncloudLocalUtils.checkPrivilegesOnDirectory(resourceProperties.getLocation());
        this.setMessageDigest(resourceProperties.getMessageDigestAlgorithm());
        log.debug("Calculate the Checksum of all Files and Directories of Directory {}", (Object)resourceProperties.getLocation());
        Files.walkFileTree(resourceProperties.getLocation(), this.getFileVisitor());
    }

    protected final FileVisitor<Path> getFileVisitor() {
        return this.fileVisitor;
    }

    private void setMessageDigest(OwncloudLocalProperties.ResourceServiceProperties.MessageDigestAlgorithm messageDigestAlgorithm) throws NoSuchAlgorithmException {
        Validate.notNull((Object)((Object)messageDigestAlgorithm));
        this.messageDigest = messageDigestAlgorithm.getMessageDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String createDirectoryChecksum(Path path, Map<Path, String> fileChecksums) {
        log.debug("Calculate the Checksum of Directory {}", (Object)path);
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                fileChecksums.entrySet().stream().filter(entry -> OwncloudLocalResourceChecksumServiceImpl.isSamePath(path, ((Path)entry.getKey()).getParent())).forEach(entry -> this.writeChecksumEntry((String)entry.getValue(), stream));
                MessageDigest messageDigest = this.messageDigest;
                synchronized (messageDigest) {
                    try {
                        this.messageDigest.reset();
                        this.messageDigest.update(stream.toByteArray());
                        String string = Hex.encodeHexString((byte[])this.messageDigest.digest());
                        return string;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throw throwable2;
                        }
                        catch (Throwable throwable22) {
                            throwable = throwable22;
                            throw throwable22;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot calculate the Checksum of Directory %s", path);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceChecksumServiceException(logMessage, e);
        }
    }

    private static boolean isSamePath(Path source, Path destination) {
        try {
            return Files.isSameFile(source, destination);
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot determine the Equality of the Directories %s and %s", source, destination);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceChecksumServiceException(logMessage, e);
        }
    }

    private void writeChecksumEntry(String checksum, ByteArrayOutputStream stream) {
        try {
            stream.write(checksum.getBytes());
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot add the Checksum %s to the ByteArrayOutputStream", checksum);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceChecksumServiceException(logMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String createFileChecksum(Path path) {
        log.debug("Calculate the Checksum of File {}", (Object)path);
        try {
            Throwable throwable = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path.toFile()));){
                MessageDigest messageDigest = this.messageDigest;
                synchronized (messageDigest) {
                    try {
                        this.messageDigest.reset();
                        byte[] buffer = IOUtils.toByteArray((InputStream)stream);
                        this.messageDigest.update(buffer);
                        String string = Hex.encodeHexString((byte[])this.messageDigest.digest());
                        return string;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throw throwable2;
                        }
                        catch (Throwable throwable22) {
                            throwable = throwable22;
                            throw throwable22;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot calculate the Checksum of File %s", path);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceChecksumServiceException(logMessage, e);
        }
    }

    @Override
    public Optional<String> getChecksum(Path path) throws OwncloudResourceException {
        return Optional.ofNullable(path).map(p -> this.checksums.get(p.toAbsolutePath().normalize()));
    }

    @Override
    public void recalculateChecksum(Path path) throws OwncloudResourceException {
        Validate.notNull((Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            log.debug("Remove the Checksum of {}", (Object)path.toAbsolutePath().normalize());
            this.checksums.remove(path.toAbsolutePath().normalize());
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.createDirectoryChecksumRecursively(path);
            return;
        }
        log.debug("Recalculate the Checksum of File {}", (Object)path.toAbsolutePath().normalize());
        String checksum = this.createFileChecksum(path);
        this.checksums.put(path.toAbsolutePath().normalize(), checksum);
        this.createDirectoryChecksumRecursively(path.getParent());
    }

    private void createDirectoryChecksumRecursively(Path path) {
        Path normalizedPath;
        OwncloudLocalProperties.ResourceServiceProperties resourceProperties = this.properties.getResourceService();
        Path rootDirectory = resourceProperties.getLocation().toAbsolutePath().normalize();
        if (OwncloudLocalResourceChecksumServiceImpl.isSamePath(rootDirectory, normalizedPath = path.toAbsolutePath().normalize())) {
            return;
        }
        log.debug("Clean the Checksum of all non-existing Files within Directory {}", (Object)normalizedPath);
        this.checksums.keySet().stream().filter(checksumPath -> OwncloudLocalResourceChecksumServiceImpl.isSamePath(checksumPath.getParent(), path)).filter(x$0 -> Files.notExists(x$0, new LinkOption[0])).forEach(this.checksums::remove);
        String checksum = this.createDirectoryChecksum(normalizedPath, this.checksums);
        this.checksums.put(normalizedPath, checksum);
        this.createDirectoryChecksumRecursively(normalizedPath.getParent());
    }

    @Override
    public void recalculateChecksums() throws OwncloudResourceException {
        OwncloudLocalProperties.ResourceServiceProperties resourceProperties = this.properties.getResourceService();
        try {
            Files.walkFileTree(resourceProperties.getLocation(), this.getFileVisitor());
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot recalculate the Checksum of all Files and Directories of Directory %s", resourceProperties.getLocation());
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceChecksumServiceException(logMessage, e);
        }
    }

    private static class InitializingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Function<Path, String> fileDigest;
        private final BiFunction<Path, Map<Path, String>, String> directoryDigest;
        private final Map<Path, String> checksums;

        private InitializingFileVisitor(Function<Path, String> fileDigest, BiFunction<Path, Map<Path, String>, String> directoryDigest, Map<Path, String> checksums) {
            this.fileDigest = fileDigest;
            this.directoryDigest = directoryDigest;
            this.checksums = checksums;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.checksums.keySet().stream().filter(path -> OwncloudLocalResourceChecksumServiceImpl.isSamePath(path.getParent(), dir)).forEach(path -> this.checksums.remove(path.toAbsolutePath().normalize()));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String checksum = this.fileDigest.apply(file);
            this.checksums.put(file.toAbsolutePath().normalize(), checksum);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            String checksum = this.directoryDigest.apply(dir, this.checksums);
            this.checksums.put(dir.toAbsolutePath().normalize(), checksum);
            return FileVisitResult.CONTINUE;
        }

        public static InitializingFileVisitorBuilder builder() {
            return new InitializingFileVisitorBuilder();
        }

        public static class InitializingFileVisitorBuilder {
            private Function<Path, String> fileDigest;
            private BiFunction<Path, Map<Path, String>, String> directoryDigest;
            private Map<Path, String> checksums;

            InitializingFileVisitorBuilder() {
            }

            public InitializingFileVisitorBuilder fileDigest(Function<Path, String> fileDigest) {
                this.fileDigest = fileDigest;
                return this;
            }

            public InitializingFileVisitorBuilder directoryDigest(BiFunction<Path, Map<Path, String>, String> directoryDigest) {
                this.directoryDigest = directoryDigest;
                return this;
            }

            public InitializingFileVisitorBuilder checksums(Map<Path, String> checksums) {
                this.checksums = checksums;
                return this;
            }

            public InitializingFileVisitor build() {
                return new InitializingFileVisitor(this.fileDigest, this.directoryDigest, this.checksums);
            }

            public String toString() {
                return "OwncloudLocalResourceChecksumServiceImpl.InitializingFileVisitor.InitializingFileVisitorBuilder(fileDigest=" + this.fileDigest + ", directoryDigest=" + this.directoryDigest + ", checksums=" + this.checksums + ")";
            }
        }
    }
}

