/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="owncloud")
@XmlAccessorType(value=XmlAccessType.FIELD)
class OwncloudLocalUserData {
    @XmlElementWrapper(name="users")
    @XmlElement(name="user")
    private Collection<User> users;
    @XmlElementWrapper(name="groups")
    @XmlElement(name="group")
    private Set<String> groups;

    public static OwncloudLocalUserDataBuilder builder() {
        return new OwncloudLocalUserDataBuilder();
    }

    public Collection<User> getUsers() {
        return this.users;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setUsers(Collection<User> users) {
        this.users = users;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwncloudLocalUserData)) {
            return false;
        }
        OwncloudLocalUserData other = (OwncloudLocalUserData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<User> this$users = this.getUsers();
        Collection<User> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwncloudLocalUserData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<User> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "OwncloudLocalUserData(users=" + this.getUsers() + ", groups=" + this.getGroups() + ")";
    }

    public OwncloudLocalUserData() {
    }

    private OwncloudLocalUserData(Collection<User> users, Set<String> groups) {
        this.users = users;
        this.groups = groups;
    }

    public static class OwncloudLocalUserDataBuilder {
        private ArrayList<User> users;
        private ArrayList<String> groups;

        OwncloudLocalUserDataBuilder() {
        }

        public OwncloudLocalUserDataBuilder user(User user) {
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.add(user);
            return this;
        }

        public OwncloudLocalUserDataBuilder users(Collection<? extends User> users) {
            if (users == null) {
                throw new NullPointerException("users cannot be null");
            }
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.addAll(users);
            return this;
        }

        public OwncloudLocalUserDataBuilder clearUsers() {
            if (this.users != null) {
                this.users.clear();
            }
            return this;
        }

        public OwncloudLocalUserDataBuilder group(String group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return this;
        }

        public OwncloudLocalUserDataBuilder groups(Collection<? extends String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups cannot be null");
            }
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return this;
        }

        public OwncloudLocalUserDataBuilder clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return this;
        }

        public OwncloudLocalUserData build() {
            Set<Object> groups;
            List<Object> users;
            switch (this.users == null ? 0 : this.users.size()) {
                case 0: {
                    users = Collections.emptyList();
                    break;
                }
                case 1: {
                    users = Collections.singletonList(this.users.get(0));
                    break;
                }
                default: {
                    users = Collections.unmodifiableList(new ArrayList<User>(this.users));
                }
            }
            switch (this.groups == null ? 0 : this.groups.size()) {
                case 0: {
                    groups = Collections.emptySet();
                    break;
                }
                case 1: {
                    groups = Collections.singleton(this.groups.get(0));
                    break;
                }
                default: {
                    groups = new LinkedHashSet(this.groups.size() < 0x40000000 ? 1 + this.groups.size() + (this.groups.size() - 3) / 3 : Integer.MAX_VALUE);
                    groups.addAll(this.groups);
                    groups = Collections.unmodifiableSet(groups);
                }
            }
            return new OwncloudLocalUserData(users, groups);
        }

        public String toString() {
            return "OwncloudLocalUserData.OwncloudLocalUserDataBuilder(users=" + this.users + ", groups=" + this.groups + ")";
        }
    }

    @XmlRootElement(name="user")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class User {
        @NotNull
        private String username;
        private String password;
        private boolean enabled;
        private String displayname;
        private String email;
        @Min(value=0L)
        private @Min(value=0L) Long quota;
        @XmlElementWrapper(name="groups")
        @XmlElement(name="group")
        private Set<String> groups;

        private static boolean $default$enabled() {
            return true;
        }

        public static UserBuilder builder() {
            return new UserBuilder();
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDisplayname() {
            return this.displayname;
        }

        public String getEmail() {
            return this.email;
        }

        public Long getQuota() {
            return this.quota;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDisplayname(String displayname) {
            this.displayname = displayname;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setQuota(Long quota) {
            this.quota = quota;
        }

        public void setGroups(Set<String> groups) {
            this.groups = groups;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !this$username.equals(other$username));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            return result;
        }

        public String toString() {
            return "OwncloudLocalUserData.User(username=" + this.getUsername() + ", enabled=" + this.isEnabled() + ", displayname=" + this.getDisplayname() + ", email=" + this.getEmail() + ", quota=" + this.getQuota() + ", groups=" + this.getGroups() + ")";
        }

        public User() {
            this.enabled = User.$default$enabled();
        }

        private User(String username, String password, boolean enabled, String displayname, String email, Long quota, Set<String> groups) {
            this.username = username;
            this.password = password;
            this.enabled = enabled;
            this.displayname = displayname;
            this.email = email;
            this.quota = quota;
            this.groups = groups;
        }

        public static class UserBuilder {
            private String username;
            private String password;
            private boolean enabled$set;
            private boolean enabled$value;
            private String displayname;
            private String email;
            private Long quota;
            private ArrayList<String> groups;

            UserBuilder() {
            }

            public UserBuilder username(String username) {
                this.username = username;
                return this;
            }

            public UserBuilder password(String password) {
                this.password = password;
                return this;
            }

            public UserBuilder enabled(boolean enabled) {
                this.enabled$value = enabled;
                this.enabled$set = true;
                return this;
            }

            public UserBuilder displayname(String displayname) {
                this.displayname = displayname;
                return this;
            }

            public UserBuilder email(String email) {
                this.email = email;
                return this;
            }

            public UserBuilder quota(Long quota) {
                this.quota = quota;
                return this;
            }

            public UserBuilder group(String group) {
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.add(group);
                return this;
            }

            public UserBuilder groups(Collection<? extends String> groups) {
                if (groups == null) {
                    throw new NullPointerException("groups cannot be null");
                }
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.addAll(groups);
                return this;
            }

            public UserBuilder clearGroups() {
                if (this.groups != null) {
                    this.groups.clear();
                }
                return this;
            }

            public User build() {
                Set<Object> groups;
                switch (this.groups == null ? 0 : this.groups.size()) {
                    case 0: {
                        groups = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        groups = Collections.singleton(this.groups.get(0));
                        break;
                    }
                    default: {
                        groups = new LinkedHashSet(this.groups.size() < 0x40000000 ? 1 + this.groups.size() + (this.groups.size() - 3) / 3 : Integer.MAX_VALUE);
                        groups.addAll(this.groups);
                        groups = Collections.unmodifiableSet(groups);
                    }
                }
                boolean enabled$value = this.enabled$value;
                if (!this.enabled$set) {
                    enabled$value = User.$default$enabled();
                }
                return new User(this.username, this.password, enabled$value, this.displayname, this.email, this.quota, groups);
            }

            public String toString() {
                return "OwncloudLocalUserData.User.UserBuilder(username=" + this.username + ", password=" + this.password + ", enabled$value=" + this.enabled$value + ", displayname=" + this.displayname + ", email=" + this.email + ", quota=" + this.quota + ", groups=" + this.groups + ")";
            }
        }
    }
}

