/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;

public class OwncloudLocalUserDataServiceImpl
implements OwncloudLocalUserDataService,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalUserDataServiceImpl.class);
    private final XmlMapper xmlMapper;
    private final ResourceLoader resourceLoader;
    private final OwncloudProperties properties;
    private Map<String, OwncloudLocalUserData.User> users = new HashMap<String, OwncloudLocalUserData.User>();
    private Set<String> groups = new HashSet<String>();

    public OwncloudLocalUserDataServiceImpl(Jackson2ObjectMapperBuilder builder, ResourceLoader resourceLoader, OwncloudProperties properties) {
        Validate.notNull((Object)builder);
        this.xmlMapper = (XmlMapper)builder.createXmlMapper(true).build();
        this.xmlMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(this.xmlMapper.getTypeFactory()));
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Load Resource from Location {}", (Object)this.properties.getLocation());
        Resource resource = this.resourceLoader.getResource(this.properties.getLocation());
        Validate.notNull((Object)resource);
        Validate.isTrue((boolean)resource.exists());
        Validate.isTrue((boolean)resource.isReadable());
        log.debug("Read the Resource {} to the Class {}", (Object)resource.getFilename(), (Object)OwncloudLocalUserData.class.getName());
        OwncloudLocalUserData resourceData = (OwncloudLocalUserData)this.xmlMapper.readValue(resource.getInputStream(), OwncloudLocalUserData.class);
        this.checkGroupReferences(resourceData);
        log.trace("Clear the Users Map");
        this.users.clear();
        log.debug("Read the Users as a Map");
        if (CollectionUtils.isNotEmpty(resourceData.getUsers())) {
            for (OwncloudLocalUserData.User user : resourceData.getUsers()) {
                this.users.put(user.getUsername(), user);
            }
        }
        log.trace("Clear the Groups Map");
        this.groups.clear();
        log.debug("Read the Groups as a Map");
        if (CollectionUtils.isNotEmpty(resourceData.getGroups())) {
            this.groups.addAll(resourceData.getGroups());
        }
        log.info("User Information from Resource Location {} successfully loaded", (Object)this.properties.getLocation());
    }

    protected void checkGroupReferences(OwncloudLocalUserData resourceData) {
        for (OwncloudLocalUserData.User user : resourceData.getUsers()) {
            if (CollectionUtils.isEmpty(user.getGroups())) continue;
            log.debug("Check, if the Groups of User {} are registered within the general Group Definitions", (Object)user.getUsername());
            if (CollectionUtils.isSubCollection(user.getGroups(), resourceData.getGroups())) continue;
            Collection unknownGroups = CollectionUtils.subtract(user.getGroups(), resourceData.getGroups());
            String exceptionMessage = String.format("User %s has unknown Groups defined: %s. Please define these Groups within <groups> or remove it from the User", user.getUsername(), unknownGroups);
            log.error(exceptionMessage);
            throw new IllegalStateException(exceptionMessage);
        }
    }

    public void destroy() throws Exception {
        log.debug("Load Resource from Location {}", (Object)this.properties.getLocation());
        Resource resource = this.resourceLoader.getResource(this.properties.getLocation());
        if (!(resource instanceof UrlResource)) {
            log.debug("Resource {} is not of Type {}. Can't synchronize changed Data", (Object)resource.getFilename(), (Object)UrlResource.class.getName());
            return;
        }
        OwncloudLocalUserData resourceData = new OwncloudLocalUserData();
        log.debug("Add Users to the Synchronization Structure {}", (Object)OwncloudLocalUserData.class.getName());
        resourceData.setUsers(this.users.values());
        log.debug("Add Groups to the Synchronization Structure {}", (Object)OwncloudLocalUserData.class.getName());
        resourceData.setGroups(this.groups);
        File file = resource.getFile();
        log.info("Save changed Data to Resource {}", (Object)resource.getFilename());
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            this.xmlMapper.writeValue((OutputStream)output, (Object)resourceData);
        }
    }

    @Override
    public OwncloudUserDetails convert(OwncloudLocalUserData.User user, boolean prefixAuthorities) {
        ArrayList authorities = new ArrayList();
        if (CollectionUtils.isNotEmpty(user.getGroups())) {
            log.trace("Put {} Owncloud-Group(s) into the Authorities-List");
            user.getGroups().stream().map(SimpleGrantedAuthority::new).forEach(authorities::add);
        }
        log.debug("Convert User {} from {} to {}", new Object[]{user.getUsername(), user.getClass(), OwncloudUserDetails.class});
        return OwncloudUserDetails.builder().username(user.getUsername()).enabled(user.isEnabled()).displayname(user.getDisplayname()).email(user.getEmail()).quota(user.getQuota()).authorities(authorities).build();
    }

    @Override
    public boolean userNotExists(String username) {
        return !this.userExists(username);
    }

    @Override
    public boolean userExists(String username) {
        return this.users.containsKey(username);
    }

    @Override
    public Collection<OwncloudLocalUserData.User> getUsers() {
        return this.users.values();
    }

    @Override
    public OwncloudLocalUserData.User getUser(String username) {
        return this.users.get(username);
    }

    @Override
    public void addUser(OwncloudLocalUserData.User user) {
        this.users.put(user.getUsername(), user);
    }

    @Override
    public void removeUser(String username) {
        this.users.remove(username);
    }

    @Override
    public boolean groupNotExists(String groupname) {
        return !this.groupExists(groupname);
    }

    @Override
    public boolean groupExists(String groupname) {
        return this.groups.contains(groupname);
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public String getGroup(String groupname) {
        for (String group : this.groups) {
            if (!group.equals(groupname)) continue;
            return group;
        }
        return null;
    }

    @Override
    public void addGroup(String group) {
        this.groups.add(group);
    }

    @Override
    public void removeGroup(String groupname) {
        this.groups.remove(groupname);
    }
}

