/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUserDetailsService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;

public class OwncloudLocalUserDetailsServiceImpl
implements OwncloudUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalUserDetailsServiceImpl.class);
    private final OwncloudLocalUserDataService localDataService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        log.debug("Get Information about User {} from the Resource Service", (Object)username);
        OwncloudLocalUserData.User user = Optional.ofNullable(this.localDataService.getUser(username)).orElseThrow(() -> {
            log.error("User {} not found", (Object)username);
            return new UsernameNotFoundException(username);
        });
        return this.localDataService.convert(user, true);
    }

    public OwncloudLocalUserDetailsServiceImpl(OwncloudLocalUserDataService localDataService) {
        this.localDataService = localDataService;
    }
}

