/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupNotFoundException;
import software.coolstuff.springframework.owncloud.model.OwncloudModificationUser;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.CheckOwncloudModification;
import software.coolstuff.springframework.owncloud.service.impl.local.AbstractOwncloudLocalUserAndGroupServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserDataService;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserServiceExtension;

public class OwncloudLocalUserServiceImpl
extends AbstractOwncloudLocalUserAndGroupServiceImpl
implements OwncloudLocalUserServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalUserServiceImpl.class);
    private final List<Consumer<OwncloudUserDetails>> saveUserListeners = new ArrayList<Consumer<OwncloudUserDetails>>();
    private final List<Consumer<String>> deleteUserListeners = new ArrayList<Consumer<String>>();

    public OwncloudLocalUserServiceImpl(OwncloudLocalUserDataService localUserDataService) {
        super(localUserDataService);
    }

    @Override
    public List<String> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<String> findAll(String filter) {
        log.debug("Get all Users with a DisplayName like {}", (Object)filter);
        ArrayList<String> filteredUsers = new ArrayList<String>();
        for (OwncloudLocalUserData.User user : this.getLocalUserDataService().getUsers()) {
            if (!StringUtils.isBlank((CharSequence)filter) && !StringUtils.contains((CharSequence)user.getDisplayname(), (CharSequence)filter)) continue;
            log.trace("add User {} to the Result", (Object)user.getUsername());
            filteredUsers.add(user.getUsername());
        }
        return filteredUsers;
    }

    @Override
    public Optional<OwncloudUserDetails> findOne(String username) {
        try {
            OwncloudLocalUserData.User user = this.getCheckedUser(username);
            return Optional.of(this.getLocalUserDataService().convert(user, false));
        }
        catch (UsernameNotFoundException ignored) {
            return Optional.empty();
        }
    }

    @Override
    @CheckOwncloudModification
    public OwncloudUserDetails save(OwncloudModificationUser modificationUser) {
        Validate.notNull((Object)modificationUser);
        Validate.notBlank((CharSequence)modificationUser.getUsername());
        log.debug("Try to get User Information of User {} from the Resource Service", (Object)modificationUser.getUsername());
        OwncloudLocalUserData.User existingUser = this.getLocalUserDataService().getUser(modificationUser.getUsername());
        if (existingUser == null) {
            Validate.notBlank((CharSequence)modificationUser.getPassword());
            log.debug("User {} not exists --> Create new User", (Object)modificationUser.getUsername());
            existingUser = new OwncloudLocalUserData.User();
            existingUser.setUsername(modificationUser.getUsername());
            existingUser.setPassword(modificationUser.getPassword());
            this.getLocalUserDataService().addUser(existingUser);
            log.info("User {} successfully created", (Object)existingUser.getUsername());
        }
        log.debug("Modify Information of User {}", (Object)existingUser.getUsername());
        existingUser.setDisplayname(modificationUser.getDisplayname());
        existingUser.setEmail(modificationUser.getEmail());
        existingUser.setQuota(modificationUser.getQuota());
        existingUser.setEnabled(modificationUser.isEnabled());
        this.manageGroups(existingUser, modificationUser);
        OwncloudUserDetails changedUserDetails = this.getLocalUserDataService().convert(existingUser, false);
        log.debug("Notify registered Listeners about changed UserDetails {}", (Object)changedUserDetails);
        this.saveUserListeners.forEach(listener -> listener.accept(changedUserDetails));
        log.info("User {} successfully modified", (Object)changedUserDetails.getUsername());
        return changedUserDetails;
    }

    private void manageGroups(OwncloudLocalUserData.User existingUser, OwncloudModificationUser newUser) {
        HashSet<String> groups = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(newUser.getGroups())) {
            log.debug("Modify the Group Memberships of User {}", (Object)existingUser.getUsername());
            for (String groupname : newUser.getGroups()) {
                if (this.getLocalUserDataService().groupNotExists(groupname)) {
                    log.error("Group {} doesn't exist. Can't assign the User {} to this non-existing Group", (Object)groupname, (Object)existingUser.getUsername());
                    throw new OwncloudGroupNotFoundException(groupname);
                }
                log.trace("Assign Group {} to User {}", (Object)groupname, (Object)existingUser.getUsername());
                groups.add(groupname);
            }
        }
        existingUser.setGroups(groups);
    }

    @Override
    @CheckOwncloudModification
    public void delete(String username) {
        Validate.notBlank((CharSequence)username);
        if (this.getLocalUserDataService().userNotExists(username)) {
            log.error("User {} doesn't exist", (Object)username);
            throw new UsernameNotFoundException(username);
        }
        log.debug("Remove User {}", (Object)username);
        this.getLocalUserDataService().removeUser(username);
        log.debug("Notify registered Listeners about removed User {}", (Object)username);
        this.deleteUserListeners.forEach(listener -> listener.accept(username));
        log.info("User {} successfully removed", (Object)username);
    }

    @Override
    public void registerSaveUserCallback(Consumer<OwncloudUserDetails> listener) {
        this.saveUserListeners.add(listener);
    }

    @Override
    public void registerDeleteUserCallback(Consumer<String> listener) {
        this.deleteUserListeners.add(listener);
    }
}

