/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalUserData;

final class OwncloudLocalUtils {
    private static final Logger log = LoggerFactory.getLogger(OwncloudLocalUtils.class);

    public static void validateUserNotNull(OwncloudLocalUserData.User user, String username) {
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
    }

    public static void checkPrivilegesOnDirectory(Path location) {
        log.debug("Check the Location {}", (Object)location);
        Validate.isTrue((boolean)Files.exists(location, new LinkOption[0]));
        Validate.isTrue((boolean)Files.isDirectory(location, new LinkOption[0]));
        Validate.isTrue((boolean)Files.isReadable(location));
        Validate.isTrue((boolean)Files.isExecutable(location));
        Validate.isTrue((boolean)Files.isWritable(location));
    }

    private OwncloudLocalUtils() {
    }
}

