/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudLocalResourceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudNoFileResourceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudResourceException;
import software.coolstuff.springframework.owncloud.service.impl.AbstractPipedStreamSynchronizerImpl;
import software.coolstuff.springframework.owncloud.service.impl.local.OwncloudLocalProperties;
import software.coolstuff.springframework.owncloud.service.impl.local.PipedOutputStreamAfterCopyEnvironment;
import software.coolstuff.springframework.owncloud.service.impl.local.PipedOutputStreamLocalSynchronizer;

class PipedOutputStreamLocalSynchronizerImpl
extends AbstractPipedStreamSynchronizerImpl
implements PipedOutputStreamLocalSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(PipedOutputStreamLocalSynchronizerImpl.class);
    private final Path outputFile;
    private final OwncloudLocalProperties owncloudLocalProperties;
    private final Optional<Consumer<PipedOutputStreamAfterCopyEnvironment>> afterCopyCallback;
    private Path temporaryFile;
    private SynchronizedPipedOutputStream pipedOutputStream;
    private PipedOutputStreamAfterCopyEnvironment afterCopyCallbackEnvironment;

    private PipedOutputStreamLocalSynchronizerImpl(Authentication authentication, URI uri, Function<URI, Path> uriResolver, OwncloudLocalProperties owncloudLocalProperties, Consumer<PipedOutputStreamAfterCopyEnvironment> afterCopyCallback) {
        super(authentication, owncloudLocalProperties, uri);
        this.outputFile = this.getOutputFile(uri, uriResolver);
        this.owncloudLocalProperties = owncloudLocalProperties;
        this.afterCopyCallback = Optional.ofNullable(afterCopyCallback);
        this.afterCopyCallbackEnvironment = PipedOutputStreamAfterCopyEnvironment.builder().path(this.outputFile).uri(this.getUri()).username(this.getUsername()).build();
    }

    private Path getOutputFile(URI uri, Function<URI, Path> uriResolver) {
        log.debug("Resolve Path from URI {}", (Object)uri);
        Path path = uriResolver.apply(uri);
        this.checkIsDirectory(path, uri);
        return path;
    }

    private void checkIsDirectory(Path path, URI uri) {
        log.debug("Check if Path {} is a Directory", (Object)path.toAbsolutePath().normalize());
        if (Files.isDirectory(path, new LinkOption[0])) {
            log.error("Cannot get OutputStream on Directory {}", (Object)path.toAbsolutePath().normalize());
            throw new OwncloudNoFileResourceException(uri);
        }
    }

    private static PipedOutputStreamLocalSynchronizer build(Authentication authentication, URI uri, Function<URI, Path> uriResolver, OwncloudLocalProperties owncloudLocalProperties, Consumer<PipedOutputStreamAfterCopyEnvironment> afterCopyCallback) {
        return new PipedOutputStreamLocalSynchronizerImpl(authentication, uri, uriResolver, owncloudLocalProperties, afterCopyCallback);
    }

    @Override
    protected String getThreadName() {
        return "pipe Content of " + this.outputFile.toAbsolutePath().normalize().toString();
    }

    @Override
    public OutputStream getOutputStream() {
        this.createTemporaryFile();
        this.preparePipedOutputStream();
        this.startThreadAndWaitForConnectedPipe();
        return this.pipedOutputStream;
    }

    private void createTemporaryFile() {
        OwncloudLocalProperties.ResourceServiceProperties resourceProperties = this.owncloudLocalProperties.getResourceService();
        String temporaryFilePrefix = resourceProperties.getPipedStreamTemporaryFilePrefix();
        try {
            log.debug("Create a temporary File with Prefix {}", (Object)temporaryFilePrefix);
            this.temporaryFile = Files.createTempFile(temporaryFilePrefix, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            String logMessage = String.format("Cannot create temporary File with Prefix %s", temporaryFilePrefix);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceException(logMessage, e);
        }
    }

    private void preparePipedOutputStream() {
        this.pipedOutputStream = new SynchronizedPipedOutputStream(this.temporaryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void createPipedStream() {
        try (PipedInputStream input = new PipedInputStream(this.pipedOutputStream);
             OutputStream output = Files.newOutputStream(this.temporaryFile, new OpenOption[0]);){
            this.setPipeReady();
            long contentLength = this.copy(input, output);
            this.afterCopyCallbackEnvironment.setContentLength(contentLength);
            return;
        }
        catch (OwncloudResourceException e) {
            this.pipedOutputStream.setOwncloudResourceException(e);
            throw e;
        }
        catch (IOException e) {
            this.pipedOutputStream.setIOException(e);
            throw new OwncloudLocalResourceException(e);
        }
        finally {
            try {
                this.handleFiles();
                this.afterCopyCallback.ifPresent(consumer -> {
                    log.debug("Reinforcement after the Stream has been closed and the temporary File has been moved");
                    consumer.accept(this.afterCopyCallbackEnvironment);
                });
            }
            catch (OwncloudResourceException e) {
                this.pipedOutputStream.setOwncloudResourceException(e);
            }
            finally {
                this.setPipeReady();
            }
        }
    }

    private void handleFiles() {
        if (this.pipedOutputStream.isExceptionAvailable()) {
            this.removeFiles();
            return;
        }
        this.moveTemporaryFile();
    }

    private void removeFiles() {
        this.removeFile(this.temporaryFile, "temporary File");
        this.removeFile(this.outputFile, "regular Output File");
    }

    private void removeFile(Path path, String fileType) {
        try {
            log.debug("Remove File {}", (Object)path.toAbsolutePath().normalize());
            Files.delete(path);
        }
        catch (IOException e) {
            log.error(String.format("Cannot remove %s %s", fileType, path.toAbsolutePath().normalize()), (Throwable)e);
            throw new OwncloudLocalResourceException("Error while removing " + fileType, e);
        }
    }

    private void moveTemporaryFile() {
        try {
            log.debug("Move temporary File {} to {}", (Object)this.temporaryFile.toAbsolutePath().normalize(), (Object)this.outputFile.toAbsolutePath().normalize());
            Files.move(this.temporaryFile, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String logMessage = String.format("Error while moving the temporary File %s to %s", this.temporaryFile.toAbsolutePath(), this.outputFile.toAbsolutePath().normalize());
            log.error(logMessage, (Throwable)e);
            throw new OwncloudLocalResourceException(logMessage, e);
        }
    }

    public static PipedOutputStreamLocalSynchronizerBuilder builder() {
        return new PipedOutputStreamLocalSynchronizerBuilder();
    }

    public static class PipedOutputStreamLocalSynchronizerBuilder {
        private Authentication authentication;
        private URI uri;
        private Function<URI, Path> uriResolver;
        private OwncloudLocalProperties owncloudLocalProperties;
        private Consumer<PipedOutputStreamAfterCopyEnvironment> afterCopyCallback;

        PipedOutputStreamLocalSynchronizerBuilder() {
        }

        public PipedOutputStreamLocalSynchronizerBuilder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public PipedOutputStreamLocalSynchronizerBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public PipedOutputStreamLocalSynchronizerBuilder uriResolver(Function<URI, Path> uriResolver) {
            this.uriResolver = uriResolver;
            return this;
        }

        public PipedOutputStreamLocalSynchronizerBuilder owncloudLocalProperties(OwncloudLocalProperties owncloudLocalProperties) {
            this.owncloudLocalProperties = owncloudLocalProperties;
            return this;
        }

        public PipedOutputStreamLocalSynchronizerBuilder afterCopyCallback(Consumer<PipedOutputStreamAfterCopyEnvironment> afterCopyCallback) {
            this.afterCopyCallback = afterCopyCallback;
            return this;
        }

        public PipedOutputStreamLocalSynchronizer build() {
            return PipedOutputStreamLocalSynchronizerImpl.build(this.authentication, this.uri, this.uriResolver, this.owncloudLocalProperties, this.afterCopyCallback);
        }

        public String toString() {
            return "PipedOutputStreamLocalSynchronizerImpl.PipedOutputStreamLocalSynchronizerBuilder(authentication=" + this.authentication + ", uri=" + this.uri + ", uriResolver=" + this.uriResolver + ", owncloudLocalProperties=" + this.owncloudLocalProperties + ", afterCopyCallback=" + this.afterCopyCallback + ")";
        }
    }

    private class SynchronizedPipedOutputStream
    extends PipedOutputStream {
        private final Path outputPath;
        private IOException iOException;
        private OwncloudResourceException owncloudResourceException;
        private boolean alreadyClosed = false;

        boolean isExceptionAvailable() {
            return this.iOException != null || this.owncloudResourceException != null;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.alreadyClosed) {
                log.warn("OutputStream has already been marked as closed");
                return;
            }
            try {
                log.debug("Close the PipedOutputStream of Path {}", (Object)this.outputPath.toAbsolutePath().normalize());
                super.close();
            }
            finally {
                this.alreadyClosed = true;
                PipedOutputStreamLocalSynchronizerImpl.this.waitForPipeReady();
            }
            this.throwExistingIOException();
            this.throwExistingOwncloudResourceException();
        }

        private void throwExistingIOException() throws IOException {
            if (this.iOException != null) {
                throw this.iOException;
            }
        }

        private void throwExistingOwncloudResourceException() {
            if (this.owncloudResourceException != null) {
                throw this.owncloudResourceException;
            }
        }

        public void setIOException(IOException iOException) {
            this.iOException = iOException;
        }

        public void setOwncloudResourceException(OwncloudResourceException owncloudResourceException) {
            this.owncloudResourceException = owncloudResourceException;
        }

        public void setAlreadyClosed(boolean alreadyClosed) {
            this.alreadyClosed = alreadyClosed;
        }

        public SynchronizedPipedOutputStream(Path outputPath) {
            this.outputPath = outputPath;
        }
    }
}

