/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import software.coolstuff.springframework.owncloud.exception.OwncloudStatusException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudInvalidAuthenticationObjectException;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.DefaultOwncloudResponseErrorHandler;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudResponseStatusChecker;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestService;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;

abstract class AbstractOwncloudRestServiceImpl
implements OwncloudRestService {
    private static final Logger log = LoggerFactory.getLogger(AbstractOwncloudRestServiceImpl.class);
    private static final String DEFAULT_PATH = "/ocs/v1.php";
    private static final String AUTHORIZATION_METHOD_PREFIX = "Basic ";
    private final RestTemplateBuilder restTemplateBuilder;
    private final OwncloudRestProperties properties;
    private final ResponseErrorHandler responseErrorHandler;
    MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private RestTemplate restTemplate;

    protected AbstractOwncloudRestServiceImpl(RestTemplateBuilder builder, OwncloudRestProperties properties) {
        this(builder, properties, (ResponseErrorHandler)new DefaultOwncloudResponseErrorHandler(SpringSecurityMessageSource.getAccessor()));
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        URL locationURL = OwncloudRestUtils.checkAndConvertLocation(this.properties.getLocation());
        this.configureRestTemplate(locationURL);
    }

    private void configureRestTemplate(URL locationURL) throws MalformedURLException {
        String rootUri = OwncloudRestUtils.appendDefaultPath(locationURL, DEFAULT_PATH);
        log.info("Create the REST-Template to URI {} to be used with the authenticated User", (Object)rootUri);
        this.restTemplate = this.restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{new FormHttpMessageConverter()}).errorHandler(this.responseErrorHandler).rootUri(rootUri).build();
        Validate.notNull((Object)this.restTemplate);
    }

    @Override
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected HttpHeaders prepareHeadersWithBasicAuthorization() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (OwncloudUtils.isAuthenticationClassNotSupported(authentication.getClass())) {
            throw new OwncloudInvalidAuthenticationObjectException(authentication, UsernamePasswordAuthenticationToken.class);
        }
        return OwncloudRestUtils.addAuthorizationHeader(authentication);
    }

    protected String getLocation() {
        return this.properties.getLocation();
    }

    protected HttpEntity<String> emptyEntity(String username, String password) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        HttpHeaders headers = OwncloudRestUtils.addAuthorizationHeader((Authentication)authenticationToken);
        return new HttpEntity((MultiValueMap)headers);
    }

    protected HttpEntity<String> emptyEntity() {
        return new HttpEntity((MultiValueMap)this.prepareHeadersWithBasicAuthorization());
    }

    protected HttpEntity<MultiValueMap<String, String>> multiValuedEntity(Map<String, List<String>> data) {
        HttpHeaders headers = this.prepareHeadersWithBasicAuthorization();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return new HttpEntity((Object)new LinkedMultiValueMap(data), (MultiValueMap)headers);
    }

    protected <T extends Ocs, E> T exchange(String url, HttpMethod method, HttpEntity<E> httpEntity, Class<T> clazz, Object ... urlVariables) {
        return this.exchange(url, method, httpEntity, clazz, this::checkFailure, urlVariables);
    }

    protected <T extends Ocs, E> T exchange(String url, HttpMethod method, HttpEntity<E> httpEntity, Class<T> clazz, OwncloudResponseStatusChecker statusChecker, Object ... urlVariables) {
        log.trace("Exchange Data by a {} Request with URL {}. Requested Class of returned Data is {}", new Object[]{method, url, clazz});
        ResponseEntity response = this.restTemplate.exchange(url, method, httpEntity, clazz, urlVariables);
        Ocs result = (Ocs)response.getBody();
        log.trace("Returned Meta-Data: {}", (Object)result.getMeta());
        log.debug("Check the returned Meta-Data for Errors");
        String authorizationUser = this.getAuthorizationUserFromHeaders(httpEntity.getHeaders());
        statusChecker.checkForFailure(authorizationUser, url, result.getMeta());
        return (T)result;
    }

    protected String getAuthorizationUserFromHeaders(HttpHeaders headers) {
        byte[] rawDecodedCredentials;
        String decodedCredentials;
        Validate.notNull((Object)headers);
        List authorizations = headers.get((Object)"Authorization");
        if (CollectionUtils.isEmpty((Collection)authorizations)) {
            return null;
        }
        String encodedCredentials = (String)authorizations.get(0);
        if (StringUtils.startsWith((CharSequence)encodedCredentials, (CharSequence)AUTHORIZATION_METHOD_PREFIX)) {
            encodedCredentials = StringUtils.substring((String)encodedCredentials, (int)AUTHORIZATION_METHOD_PREFIX.length());
        }
        if (!StringUtils.contains((CharSequence)(decodedCredentials = new String(rawDecodedCredentials = Base64.getDecoder().decode(encodedCredentials.getBytes()))), (int)58)) {
            return null;
        }
        return StringUtils.split((String)decodedCredentials, (char)':')[0];
    }

    protected void checkFailure(String username, String uri, Ocs.Meta meta) throws OwncloudStatusException {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", username, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
            case 998: {
                log.error("Error 998: {}", (Object)meta.getMessage());
                throw new UsernameNotFoundException(meta.getMessage());
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    protected OwncloudUserDetails convert(String username, Ocs.User user, Ocs.Groups groupsFromBackend) {
        ArrayList authorities = new ArrayList();
        if (this.isAnyOwncloudGroupAvailable(groupsFromBackend)) {
            log.trace("Put {} Owncloud-Group(s) into the Authorities- and Group-List");
            groupsFromBackend.getData().getGroups().stream().map(Ocs.Groups.Data.Group::getGroup).map(SimpleGrantedAuthority::new).forEach(authorities::add);
        }
        log.debug("Convert User {} from {} to {}", new Object[]{username, user.getClass(), OwncloudUserDetails.class});
        return OwncloudUserDetails.builder().username(username).enabled(user.getData().isEnabled()).displayname(user.getData().getDisplayname()).email(user.getData().getEmail()).quota(user.getData().getQuota().getTotal()).authorities(authorities).build();
    }

    private boolean isAnyOwncloudGroupAvailable(Ocs.Groups groups) {
        return groups != null && groups.getData() != null && groups.getData().getGroups() != null;
    }

    protected AbstractOwncloudRestServiceImpl(RestTemplateBuilder restTemplateBuilder, OwncloudRestProperties properties, ResponseErrorHandler responseErrorHandler) {
        this.restTemplateBuilder = restTemplateBuilder;
        this.properties = properties;
        this.responseErrorHandler = responseErrorHandler;
    }

    protected MessageSourceAccessor getMessages() {
        return this.messages;
    }
}

