/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestOperations;
import software.coolstuff.springframework.owncloud.service.impl.AbstractPipedStreamSynchronizerImpl;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;

abstract class AbstractPipedStreamRestSynchronizerImpl
extends AbstractPipedStreamSynchronizerImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractPipedStreamRestSynchronizerImpl.class);
    private final RestOperations restOperations;
    private final Optional<BiFunction<URI, String, URI>> uriResolver;

    protected AbstractPipedStreamRestSynchronizerImpl(Authentication authentication, URI uri, OwncloudProperties owncloudProperties, RestOperations restOperations, BiFunction<URI, String, URI> uriResolver) {
        super(authentication, owncloudProperties, uri);
        this.restOperations = restOperations;
        this.uriResolver = Optional.ofNullable(uriResolver);
    }

    @Override
    protected final String getThreadName() {
        return this.getHttpMethod() + " " + this.getResolvedURI();
    }

    protected void execute(ExecutionEnvironment executionEnvironment) {
        Validate.notNull((Object)executionEnvironment);
        Optional<ConsumerWithoutArgument> afterExecutionCallback = executionEnvironment.getAfterExecutionCallback();
        try {
            this.callRestWith(executionEnvironment);
        }
        catch (RuntimeException runtimeException) {
            executionEnvironment.getRuntimeExceptionHandler().ifPresent(consumer -> consumer.accept(runtimeException));
            throw runtimeException;
        }
        finally {
            afterExecutionCallback.ifPresent(ConsumerWithoutArgument::apply);
        }
    }

    private void callRestWith(ExecutionEnvironment executionEnvironment) {
        RequestCallback requestCallback = executionEnvironment.getRequestCallback();
        VoidResponseExtractor responseExtractor = executionEnvironment.getResponseExtractor();
        URI uri = this.getResolvedURI();
        HttpMethod httpMethod = this.getHttpMethod();
        this.restOperations.execute(uri, httpMethod, clientHttpRequest -> this.wrapRequestCallback(clientHttpRequest, requestCallback), response -> {
            if (responseExtractor != null) {
                responseExtractor.extractData(response);
            }
            return null;
        });
    }

    protected URI getResolvedURI() {
        URI unresolvedUri = this.getUri();
        return this.uriResolver.map(resolver -> (URI)resolver.apply(unresolvedUri, this.getUsername())).orElse(unresolvedUri);
    }

    protected abstract HttpMethod getHttpMethod();

    private void wrapRequestCallback(ClientHttpRequest clientHttpRequest, RequestCallback requestCallback) throws IOException {
        log.debug("Execute {} on {}", (Object)clientHttpRequest.getMethod(), (Object)clientHttpRequest.getURI());
        OwncloudRestUtils.addAuthorizationHeader(clientHttpRequest.getHeaders(), this.getAuthentication());
        this.addKeepAliveConnectionHeader(clientHttpRequest);
        if (requestCallback != null) {
            requestCallback.doWithRequest(clientHttpRequest);
        }
    }

    private void addKeepAliveConnectionHeader(ClientHttpRequest clientHttpRequest) {
        log.debug("Set the Connection Header to keep-alive");
        HttpHeaders headers = clientHttpRequest.getHeaders();
        headers.add("Connection", "keep-alive");
    }

    static class ExecutionEnvironment {
        private final RequestCallback requestCallback;
        private VoidResponseExtractor responseExtractor;
        private Consumer<RuntimeException> runtimeExceptionHandler;
        private ConsumerWithoutArgument afterExecutionCallback;

        Optional<Consumer<RuntimeException>> getRuntimeExceptionHandler() {
            return Optional.ofNullable(this.runtimeExceptionHandler);
        }

        Optional<ConsumerWithoutArgument> getAfterExecutionCallback() {
            return Optional.ofNullable(this.afterExecutionCallback);
        }

        public static ExecutionEnvironmentBuilder builder() {
            return new ExecutionEnvironmentBuilder();
        }

        public RequestCallback getRequestCallback() {
            return this.requestCallback;
        }

        public VoidResponseExtractor getResponseExtractor() {
            return this.responseExtractor;
        }

        private ExecutionEnvironment(RequestCallback requestCallback, VoidResponseExtractor responseExtractor, Consumer<RuntimeException> runtimeExceptionHandler, ConsumerWithoutArgument afterExecutionCallback) {
            this.requestCallback = requestCallback;
            this.responseExtractor = responseExtractor;
            this.runtimeExceptionHandler = runtimeExceptionHandler;
            this.afterExecutionCallback = afterExecutionCallback;
        }

        public static class ExecutionEnvironmentBuilder {
            private RequestCallback requestCallback;
            private VoidResponseExtractor responseExtractor;
            private Consumer<RuntimeException> runtimeExceptionHandler;
            private ConsumerWithoutArgument afterExecutionCallback;

            ExecutionEnvironmentBuilder() {
            }

            public ExecutionEnvironmentBuilder requestCallback(RequestCallback requestCallback) {
                this.requestCallback = requestCallback;
                return this;
            }

            public ExecutionEnvironmentBuilder responseExtractor(VoidResponseExtractor responseExtractor) {
                this.responseExtractor = responseExtractor;
                return this;
            }

            public ExecutionEnvironmentBuilder runtimeExceptionHandler(Consumer<RuntimeException> runtimeExceptionHandler) {
                this.runtimeExceptionHandler = runtimeExceptionHandler;
                return this;
            }

            public ExecutionEnvironmentBuilder afterExecutionCallback(ConsumerWithoutArgument afterExecutionCallback) {
                this.afterExecutionCallback = afterExecutionCallback;
                return this;
            }

            public ExecutionEnvironment build() {
                return new ExecutionEnvironment(this.requestCallback, this.responseExtractor, this.runtimeExceptionHandler, this.afterExecutionCallback);
            }

            public String toString() {
                return "AbstractPipedStreamRestSynchronizerImpl.ExecutionEnvironment.ExecutionEnvironmentBuilder(requestCallback=" + this.requestCallback + ", responseExtractor=" + this.responseExtractor + ", runtimeExceptionHandler=" + this.runtimeExceptionHandler + ", afterExecutionCallback=" + this.afterExecutionCallback + ")";
            }
        }
    }

    @FunctionalInterface
    static interface ConsumerWithoutArgument {
        public void apply();
    }

    @FunctionalInterface
    static interface VoidResponseExtractor {
        public void extractData(ClientHttpResponse var1) throws IOException;
    }
}

