/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.client.DefaultResponseErrorHandler;

class DefaultOwncloudResponseErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultOwncloudResponseErrorHandler.class);
    protected final MessageSourceAccessor messages;

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            HttpStatus statusCode = response.getStatusCode();
            if (HttpStatus.UNAUTHORIZED.compareTo((Enum)statusCode) == 0) {
                log.warn(response.getStatusText());
                throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
            }
            super.handleError(response);
        }
        catch (BadCredentialsException notLogged) {
            throw notLogged;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public DefaultOwncloudResponseErrorHandler(MessageSourceAccessor messages) {
        this.messages = messages;
    }
}

