/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import software.coolstuff.springframework.owncloud.exception.OwncloudStatusException;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractOwncloudRestServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserDetailsService;

public class OwncloudRestAuthenticationProviderImpl
extends AbstractOwncloudRestServiceImpl
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestAuthenticationProviderImpl.class);
    private final OwncloudRestUserDetailsService userDetailsService;
    private final OwncloudGrantedAuthoritiesMappingService grantedAuthoritiesMappingService;

    public OwncloudRestAuthenticationProviderImpl(RestTemplateBuilder builder, OwncloudRestProperties properties, OwncloudRestUserDetailsService userDetailsService, OwncloudGrantedAuthoritiesMappingService grantedAuthoritiesMappingService) {
        super(builder, properties);
        this.userDetailsService = userDetailsService;
        this.grantedAuthoritiesMappingService = grantedAuthoritiesMappingService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String password;
        String username = authentication.getName();
        if (StringUtils.isBlank((CharSequence)username)) {
            log.warn("Username is null or empty");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        String string = password = authentication.getCredentials() != null ? authentication.getCredentials().toString() : null;
        if (StringUtils.isBlank((CharSequence)password)) {
            log.warn("Password is null or empty");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
        }
        log.debug("Try to get Information about User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.User user = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(username, password), Ocs.User.class, username);
        if (!user.getData().isEnabled()) {
            log.error("User {} is disabled", (Object)username);
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "Disabled"));
        }
        log.debug("Set a new UsernamePasswordAuthenticationToken with User {} to the SecurityContextHolder", (Object)username);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        log.info("User {} has been successfully authenticated. Get Information from UserDetailsService", (Object)username);
        OwncloudUserDetails owncloudUserDetails = this.userDetailsService.loadPreloadedUserByUsername(username, user);
        log.trace("Set the Password of User {} to the Authentication Object", (Object)username);
        owncloudUserDetails.setPassword(password);
        return new UsernamePasswordAuthenticationToken((Object)owncloudUserDetails, (Object)password, this.grantedAuthoritiesMappingService.mapGrantedAuthorities(owncloudUserDetails));
    }

    @Override
    protected void checkFailure(String username, String uri, Ocs.Meta metaInformation) throws OwncloudStatusException {
        if ("ok".equals(metaInformation.getStatus())) {
            return;
        }
        log.warn("Authentication Failure with Authorization User {} and Code {} from Backend. Returned Failure-Message: {}", new Object[]{username, metaInformation.getStatuscode(), metaInformation.getMessage()});
        throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad Credentials"));
    }

    public boolean supports(Class<?> authentication) {
        return OwncloudUtils.isAuthenticationClassSupported(authentication);
    }
}

