/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.net.MalformedURLException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGroupService;
import software.coolstuff.springframework.owncloud.service.api.OwncloudResourceService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudGrantedAuthoritiesMappingService;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestAuthenticationProviderImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestGroupServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestResourceServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserDetailsService;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserDetailsServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserServiceExtension;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.SardineCacheLoader;

@Configuration
@ConditionalOnClass(value={RestTemplateBuilder.class, MappingJackson2XmlHttpMessageConverter.class})
@ConditionalOnExpression(value="#{!('${owncloud.location}' matches 'file:.*') and !('${owncloud.location}' matches 'classpath:.*')}")
@EnableConfigurationProperties(value={OwncloudRestProperties.class})
public class OwncloudRestAutoConfiguration {
    private final RestTemplateBuilder restTemplateBuilder;
    private final OwncloudRestProperties owncloudRestProperties;
    private final OwncloudGrantedAuthoritiesMappingService owncloudGrantedAuthoritiesMappingService;

    @Bean
    public OwncloudRestUserServiceExtension owncloudUserRestService() {
        return new OwncloudRestUserServiceImpl(this.restTemplateBuilder, this.owncloudRestProperties);
    }

    @Bean
    public OwncloudGroupService owncloudGroupRestService() {
        return new OwncloudRestGroupServiceImpl(this.restTemplateBuilder, this.owncloudRestProperties);
    }

    @Bean
    @Qualifier(value="owncloudAuthenticationProvider")
    @ConditionalOnMissingBean(value={OwncloudRestAuthenticationProviderImpl.class})
    public OwncloudRestAuthenticationProviderImpl owncloudRestAuthenticationProvider() {
        return new OwncloudRestAuthenticationProviderImpl(this.restTemplateBuilder, this.owncloudRestProperties, this.owncloudRestUserDetailsService(), this.owncloudGrantedAuthoritiesMappingService);
    }

    @Bean
    @Qualifier(value="owncloudUserDetailsService")
    @ConditionalOnMissingBean(value={OwncloudRestUserDetailsServiceImpl.class})
    public OwncloudRestUserDetailsService owncloudRestUserDetailsService() {
        return new OwncloudRestUserDetailsServiceImpl(this.restTemplateBuilder, this.owncloudRestProperties);
    }

    @Bean
    public OwncloudResourceService owncloudResourceService() throws MalformedURLException {
        return new OwncloudRestResourceServiceImpl(this.restTemplateBuilder, this.owncloudRestProperties, this.sardineCacheLoader(), this.owncloudUserRestService());
    }

    @Bean
    @ConditionalOnMissingBean(value={SardineCacheLoader.class})
    public SardineCacheLoader sardineCacheLoader() {
        return new SardineCacheLoader();
    }

    public OwncloudRestAutoConfiguration(RestTemplateBuilder restTemplateBuilder, OwncloudRestProperties owncloudRestProperties, OwncloudGrantedAuthoritiesMappingService owncloudGrantedAuthoritiesMappingService) {
        this.restTemplateBuilder = restTemplateBuilder;
        this.owncloudRestProperties = owncloudRestProperties;
        this.owncloudGrantedAuthoritiesMappingService = owncloudGrantedAuthoritiesMappingService;
    }
}

