/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDeniedException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupAlreadyExistsException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupNotFoundException;
import software.coolstuff.springframework.owncloud.service.api.OwncloudGroupService;
import software.coolstuff.springframework.owncloud.service.impl.CheckOwncloudModification;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractOwncloudRestServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;

public class OwncloudRestGroupServiceImpl
extends AbstractOwncloudRestServiceImpl
implements OwncloudGroupService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestGroupServiceImpl.class);
    private static final String GROUP_PATH = "/cloud/groups/{group}";

    OwncloudRestGroupServiceImpl(RestTemplateBuilder builder, OwncloudRestProperties properties) {
        super(builder, properties);
    }

    @Override
    public List<String> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<String> findAll(String filter) {
        Ocs.Groups ocsGroups = null;
        if (StringUtils.isBlank((CharSequence)filter)) {
            log.debug("Get all Groups by Filter Criteria {} from Location {}", (Object)filter, (Object)this.getLocation());
            ocsGroups = this.exchange("/cloud/groups", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, new Object[0]);
        } else {
            log.debug("Get all Groups from Location {}", (Object)this.getLocation());
            ocsGroups = this.exchange("/cloud/groups?search={filter}", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, filter);
        }
        return OwncloudRestUtils.convertGroups(ocsGroups);
    }

    @Override
    public List<String> findAllUsers(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        log.debug("Get all Users assigned to Group {} from Location {}", (Object)groupname, (Object)this.getLocation());
        Ocs.Users users = this.exchange(GROUP_PATH, HttpMethod.GET, this.emptyEntity(), Ocs.Users.class, (String authorizationUser, String uri, Ocs.Meta meta) -> {
            if ("ok".equals(meta.getStatus())) {
                return;
            }
            switch (meta.getStatuscode()) {
                case 997: {
                    String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authorizationUser, uri);
                    log.warn("Error 997: {}", (Object)exceptionMessage);
                    throw new AccessDeniedException(exceptionMessage);
                }
                case 998: {
                    log.error("Error 998: Group {} not found", (Object)groupname);
                    throw new OwncloudGroupNotFoundException(groupname);
                }
            }
            String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
            log.error(exceptionMessage);
            throw new IllegalStateException(exceptionMessage);
        }, groupname);
        return this.convertUsers(users);
    }

    private List<String> convertUsers(Ocs.Users ocsUsers) {
        ArrayList<String> users = new ArrayList<String>();
        if (this.isUsersNotNull(ocsUsers)) {
            for (Ocs.Users.Data.Element element : ocsUsers.getData().getUsers()) {
                log.trace("Add User {} to the Result List", (Object)element.getElement());
                users.add(element.getElement());
            }
        }
        return users;
    }

    private boolean isUsersNotNull(Ocs.Users ocsUsers) {
        return ocsUsers != null && ocsUsers.getData() != null && ocsUsers.getData().getUsers() != null;
    }

    @Override
    public List<String> findAllGroups(String username) {
        Validate.notBlank((CharSequence)username);
        log.debug("Get all Groups assigned to User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.Groups ocsGroups = this.exchange("/cloud/users/{user}/groups", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, username);
        return OwncloudRestUtils.convertGroups(ocsGroups);
    }

    @Override
    @CheckOwncloudModification
    public void create(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        log.trace("Create Message Body for Create Request of Group {}", (Object)groupname);
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("groupid", Lists.newArrayList((Object[])new String[]{groupname}));
        log.debug("Create Group {} on Location {}", (Object)groupname, (Object)this.getLocation());
        this.exchange(GROUP_PATH, HttpMethod.POST, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkCreateGroup(authenticatedUser, uri, meta, groupname), groupname);
        log.info("Group {} successfully created on Location {}", (Object)groupname, (Object)this.getLocation());
    }

    private void checkCreateGroup(String authenticatedUser, String uri, Ocs.Meta meta, String groupname) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: {}", (Object)meta.getMessage());
                throw new IllegalArgumentException(meta.getMessage());
            }
            case 102: {
                log.warn("Error 102: Group {} already exists", (Object)groupname);
                throw new OwncloudGroupAlreadyExistsException(groupname);
            }
            case 103: {
                String exceptionMessage = String.format("Failed to create Group %s. Reason: %s", groupname, StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
                log.error("Error 103: {}", (Object)exceptionMessage);
                throw new IllegalStateException(exceptionMessage);
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    @Override
    @CheckOwncloudModification
    public void delete(String groupname) {
        Validate.notBlank((CharSequence)groupname);
        log.trace("Create Message Body for Delete Request of Group {}", (Object)groupname);
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("groupid", Lists.newArrayList((Object[])new String[]{groupname}));
        log.debug("Delete Group {} on Location {}", (Object)groupname, (Object)this.getLocation());
        this.exchange(GROUP_PATH, HttpMethod.DELETE, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkDeleteGroup(authenticatedUser, uri, meta, groupname), groupname);
        log.info("Group {} successfully removed from Location {}", (Object)groupname, (Object)this.getLocation());
    }

    private void checkDeleteGroup(String authenticatedUser, String uri, Ocs.Meta meta, String groupname) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.warn("Error 101: Group {} not exists", (Object)groupname);
                throw new OwncloudGroupNotFoundException(groupname);
            }
            case 102: {
                String exceptionMessage = String.format("Failed to delete Group %s. Reason: %s", groupname, StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
                log.error("Error 102: {}", (Object)exceptionMessage);
                throw new IllegalStateException(exceptionMessage);
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }
}

