/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudNoDirectoryResourceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudNoFileResourceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudResourceNotFoundException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudRestResourceException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudSardineCacheException;
import software.coolstuff.springframework.owncloud.model.OwncloudFileResource;
import software.coolstuff.springframework.owncloud.model.OwncloudQuota;
import software.coolstuff.springframework.owncloud.model.OwncloudResource;
import software.coolstuff.springframework.owncloud.service.api.OwncloudResourceService;
import software.coolstuff.springframework.owncloud.service.impl.OwncloudUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudResolveRootUriService;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestFileResourceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestResourceExtension;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestResourceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestService;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserServiceExtension;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.PipedInputStreamRestSynchronizer;
import software.coolstuff.springframework.owncloud.service.impl.rest.PipedOutputStreamRestSynchronizer;
import software.coolstuff.springframework.owncloud.service.impl.rest.RestClientExceptionHandlerEnvironment;
import software.coolstuff.springframework.owncloud.service.impl.rest.SardineCacheLoader;

public class OwncloudRestResourceServiceImpl
implements OwncloudResourceService,
OwncloudRestService,
OwncloudResolveRootUriService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestResourceServiceImpl.class);
    private static final String URI_SUFFIX = "/remote.php/dav/files/{username}/";
    private static final String SLASH = "/";
    private static final String QUOTE = "\"";
    private final RestTemplate restTemplate;
    private final OwncloudRestProperties properties;
    private final SardineCacheLoader sardineCacheLoader;
    private final OwncloudRestUserServiceExtension userService;
    private final String rootUri;
    private LoadingCache<String, Sardine> sardineCache;

    public OwncloudRestResourceServiceImpl(RestTemplateBuilder builder, OwncloudRestProperties properties, SardineCacheLoader sardineCacheLoader, OwncloudRestUserServiceExtension userService) throws MalformedURLException {
        this.properties = properties;
        this.sardineCacheLoader = sardineCacheLoader;
        this.userService = userService;
        URL locationURL = OwncloudRestUtils.checkAndConvertLocation(properties.getLocation());
        this.rootUri = this.appendOptionalSuffix(locationURL, URI_SUFFIX);
        log.debug("Build the RestTemplate based on Root URI {}", (Object)this.rootUri);
        this.restTemplate = builder.requestFactory(HttpComponentsClientHttpRequestFactory.class).messageConverters(new HttpMessageConverter[]{new ByteArrayHttpMessageConverter()}).rootUri(this.rootUri).build();
    }

    protected String appendOptionalSuffix(URL url, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return url.toString();
        }
        return StringUtils.stripEnd((String)url.toString(), (String)SLASH) + SLASH + StringUtils.stripStart((String)suffix, (String)SLASH);
    }

    @Override
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        log.debug("Build the Sardine Cache");
        this.sardineCache = this.buildSardineCache();
    }

    protected LoadingCache<String, Sardine> buildSardineCache() {
        OwncloudRestProperties.ResourceServiceProperties.CacheProperties cacheProperties = this.properties.getResourceService().getSardineCache();
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (cacheProperties.getConcurrencyLevel() != null) {
            builder.concurrencyLevel(cacheProperties.getConcurrencyLevel().intValue());
        }
        if (cacheProperties.getExpireAfterAccess() != null && cacheProperties.getExpireAfterAccessTimeUnit() != null) {
            builder.expireAfterAccess(cacheProperties.getExpireAfterAccess().longValue(), cacheProperties.getExpireAfterAccessTimeUnit());
        }
        if (cacheProperties.getExpireAfterWrite() != null && cacheProperties.getExpireAfterWriteTimeUnit() != null) {
            builder.expireAfterWrite(cacheProperties.getExpireAfterWrite().longValue(), cacheProperties.getExpireAfterWriteTimeUnit());
        }
        if (cacheProperties.getInitialCapacity() != null) {
            builder.initialCapacity(cacheProperties.getInitialCapacity().intValue());
        }
        if (cacheProperties.getMaximumSize() != null) {
            builder.maximumSize(cacheProperties.getMaximumSize().longValue());
        }
        if (cacheProperties.getMaximumWeight() != null) {
            builder.maximumWeight(cacheProperties.getMaximumWeight().longValue());
        }
        if (cacheProperties.getRefreshAfterWrite() != null && cacheProperties.getRefreshAfterWriteTimeUnit() != null) {
            builder.refreshAfterWrite(cacheProperties.getRefreshAfterWrite().longValue(), cacheProperties.getRefreshAfterWriteTimeUnit());
        }
        return builder.build((CacheLoader)this.sardineCacheLoader);
    }

    @Override
    public List<OwncloudResource> list(URI relativeTo) {
        URI searchPath = this.resolveAsDirectoryURI(relativeTo);
        try {
            return this.listAllOwncloudResourcesOf(searchPath);
        }
        catch (SardineException e) {
            SardineExceptionHandlerEnvironment handlerEnvironment = SardineExceptionHandlerEnvironment.builder().uri(URI.create(searchPath.toString())).sardineException(e).build();
            return this.handleSardineException(handlerEnvironment).map(xva$0 -> Lists.newArrayList((Object[])new OwncloudResource[]{xva$0})).orElse(new ArrayList());
        }
        catch (IOException e) {
            throw new OwncloudRestResourceException(e);
        }
    }

    private URI resolveAsDirectoryURI(URI relativeTo) {
        URI userRoot = this.getUserRoot();
        if (relativeTo == null || StringUtils.isBlank((CharSequence)relativeTo.getPath())) {
            return userRoot;
        }
        return URI.create(UriComponentsBuilder.fromUri((URI)userRoot).path(relativeTo.getPath()).path(SLASH).toUriString()).normalize();
    }

    private URI getUserRoot() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.getResolvedRootUri(authentication.getName());
    }

    @Override
    public URI getResolvedRootUri(String username) {
        log.debug("Get base URI of User {} (under Root URI {})", (Object)username, (Object)this.rootUri);
        return URI.create(StringUtils.replace((String)this.rootUri, (String)"{username}", (String)username));
    }

    private List<OwncloudResource> listAllOwncloudResourcesOf(URI searchPath) throws IOException {
        ArrayList<OwncloudResource> owncloudResources = new ArrayList<OwncloudResource>();
        this.listOwncloudResourcesOf(searchPath).peek(owncloudResource -> log.debug("Add Owncloud Resource {}", owncloudResource)).forEach(owncloudResources::add);
        if (this.isAddParentResourceToCollection(searchPath, owncloudResources)) {
            this.listParentOwncloudResourcesOf(searchPath).peek(owncloudResource -> log.debug("Add Owncloud Resource {}", owncloudResource)).forEach(owncloudResources::add);
        }
        return owncloudResources;
    }

    private Stream<OwncloudResource> listOwncloudResourcesOf(URI searchPath) throws IOException {
        Sardine sardine = this.getSardine();
        URI userRoot = this.getUserRoot();
        log.debug("Get the List of WebDAV Resources based by URI {}", (Object)searchPath);
        List davResources = sardine.list(searchPath.toString());
        OwncloudResourceConversionProperties searchPathConversionProperties = OwncloudResourceConversionProperties.builder().rootPath(userRoot).searchPath(searchPath).renamedSearchPath(".").build();
        return davResources.stream().map(davResource -> this.createOwncloudResourceFrom((DavResource)davResource, searchPathConversionProperties)).map(modifyingResource -> this.renameOwncloudResource((OwncloudRestResourceExtension)modifyingResource, searchPathConversionProperties));
    }

    protected Sardine getSardine() throws OwncloudSardineCacheException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String username = authentication.getName();
        try {
            log.debug("Get the Sardine Implementation of User {}", (Object)username);
            return (Sardine)this.sardineCache.get((Object)username);
        }
        catch (Exception e) {
            String logMessage = String.format("Cannot get the Sardine Implementation based by User %s from the Sardine Cache", username);
            log.error(logMessage, (Throwable)e);
            throw new OwncloudSardineCacheException(logMessage, e);
        }
    }

    private OwncloudRestResourceExtension createOwncloudResourceFrom(DavResource davResource, OwncloudResourceConversionProperties conversionProperties) {
        log.debug("Create OwncloudResource based on DavResource {}", (Object)davResource.getHref());
        MediaType mediaType = MediaType.valueOf((String)davResource.getContentType());
        URI rootPath = conversionProperties.getRootPath();
        URI href = rootPath.resolve(davResource.getHref());
        String name = davResource.getName();
        if (davResource.isDirectory() && href.equals(rootPath)) {
            name = SLASH;
        }
        LocalDateTime lastModifiedAt = LocalDateTime.ofInstant(davResource.getModified().toInstant(), ZoneId.systemDefault());
        href = rootPath.relativize(href);
        href = URI.create(SLASH).resolve(href).normalize();
        OwncloudRestResourceImpl owncloudResource = OwncloudRestResourceImpl.builder().href(href).name(name).lastModifiedAt(lastModifiedAt).mediaType(mediaType).eTag(StringUtils.strip((String)davResource.getEtag(), (String)QUOTE)).build();
        if (davResource.isDirectory()) {
            return owncloudResource;
        }
        return OwncloudRestFileResourceImpl.fileBuilder().owncloudResource(owncloudResource).contentLength(davResource.getContentLength()).build();
    }

    private OwncloudRestResourceExtension renameOwncloudResource(OwncloudRestResourceExtension resource, OwncloudResourceConversionProperties conversionProperties) {
        if (StringUtils.isBlank((CharSequence)conversionProperties.getRenamedSearchPath())) {
            return resource;
        }
        URI resourcePath = URI.create(UriComponentsBuilder.fromUri((URI)conversionProperties.getRootPath()).path(resource.getHref().getPath()).toUriString()).normalize();
        if (conversionProperties.getSearchPath().equals(resourcePath)) {
            log.debug("Rename OwncloudResource {} based by {} to {}", new Object[]{resource.getName(), resource.getHref(), conversionProperties.getRenamedSearchPath()});
            resource.setName(conversionProperties.getRenamedSearchPath());
        }
        return resource;
    }

    private boolean isAddParentResourceToCollection(URI searchPath, List<OwncloudResource> owncloudResources) {
        return this.properties.getResourceService().isAddRelativeDownPath() && this.isNotResolvedToRootURI(searchPath) && this.containsNotOnlyOneFileResource(owncloudResources);
    }

    private boolean isNotResolvedToRootURI(URI path) {
        return !this.isResolvedToRootURI(path);
    }

    private boolean isResolvedToRootURI(URI path) {
        URI userRoot = this.getUserRoot();
        if (path.isAbsolute()) {
            return userRoot.equals(path);
        }
        return userRoot.equals(this.resolveAsDirectoryURI(path));
    }

    private boolean containsNotOnlyOneFileResource(List<OwncloudResource> owncloudResources) {
        return !this.containsOnlyOneFileResource(owncloudResources);
    }

    private boolean containsOnlyOneFileResource(List<OwncloudResource> owncloudResources) {
        return owncloudResources.size() == 1 && !OwncloudUtils.isDirectory(owncloudResources.get(0));
    }

    private Stream<OwncloudResource> listParentOwncloudResourcesOf(URI searchPath) throws IOException {
        URI parentPath = URI.create(UriComponentsBuilder.fromUri((URI)searchPath.normalize()).path("/../").toUriString()).normalize();
        log.debug("Get the List of WebDAV Resources based by Parent URI {}", (Object)parentPath);
        URI userRoot = this.getUserRoot();
        OwncloudResourceConversionProperties parentDirectoryConversionProperties = OwncloudResourceConversionProperties.builder().rootPath(userRoot).searchPath(parentPath).renamedSearchPath("..").build();
        Sardine sardine = this.getSardine();
        List davResources = sardine.list(parentPath.toString(), 0);
        return davResources.stream().map(davResource -> this.createOwncloudResourceFrom((DavResource)davResource, parentDirectoryConversionProperties)).map(modifyingResource -> this.renameOwncloudResource((OwncloudRestResourceExtension)modifyingResource, parentDirectoryConversionProperties));
    }

    private Optional<OwncloudResource> handleSardineException(SardineExceptionHandlerEnvironment environment) {
        SardineException sardineException = environment.getSardineException();
        int statusCode = sardineException.getStatusCode();
        Function<SardineExceptionHandlerEnvironment, Optional<OwncloudResource>> statusCodeHandler = environment.getHandlerFor(statusCode);
        if (statusCodeHandler != null) {
            return statusCodeHandler.apply(environment);
        }
        log.error("Unmapped HTTP-Status {}. Reason-Phrase: {}", (Object)statusCode, (Object)sardineException.getResponsePhrase());
        throw new OwncloudRestResourceException("Unmapped returned HTTP-Status " + statusCode, sardineException);
    }

    @Override
    public Optional<OwncloudResource> find(URI path) {
        URI searchPath = this.resolveAsDirectoryURI(path);
        try {
            return this.findOwncloudResourceOn(searchPath);
        }
        catch (SardineException e) {
            SardineExceptionHandlerEnvironment handlerEnvironment = SardineExceptionHandlerEnvironment.builder().uri(URI.create(searchPath.toString())).sardineException(e).build();
            handlerEnvironment.registerHandler(404, environment -> Optional.empty());
            return this.handleSardineException(handlerEnvironment);
        }
        catch (IOException e) {
            throw new OwncloudRestResourceException(e);
        }
    }

    private Optional<OwncloudResource> findOwncloudResourceOn(URI searchPath) throws IOException {
        List davResources = this.getSardine().list(searchPath.toString(), 0);
        OwncloudResourceConversionProperties conversionProperties = OwncloudResourceConversionProperties.builder().rootPath(this.getUserRoot()).searchPath(searchPath).build();
        return Optional.ofNullable(davResources.stream().findFirst().map(davResource -> this.createOwncloudResourceFrom((DavResource)davResource, conversionProperties)).orElse(null));
    }

    @Override
    public OwncloudResource createDirectory(URI directory) {
        Optional<OwncloudResource> existingDirectory = this.find(directory);
        if (existingDirectory.isPresent()) {
            return existingDirectory.filter(OwncloudUtils::isDirectory).orElseThrow(() -> new OwncloudNoDirectoryResourceException(directory));
        }
        return this.createNonExistingDirectory(directory);
    }

    private OwncloudResource createNonExistingDirectory(URI directory) {
        URI directoryURI = this.resolveAsDirectoryURI(directory);
        try {
            this.getSardine().createDirectory(directoryURI.toString());
            return this.find(directory).orElse(null);
        }
        catch (SardineException e) {
            SardineExceptionHandlerEnvironment handlerEnvironment = SardineExceptionHandlerEnvironment.builder().uri(URI.create(directory.toString())).sardineException(e).build();
            return this.handleSardineException(handlerEnvironment).get();
        }
        catch (IOException e) {
            throw new OwncloudRestResourceException(e);
        }
    }

    @Override
    public void delete(OwncloudResource resource) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        URI resolvedUri = this.resolveAsFileURI(resource.getHref(), authentication.getName());
        try {
            this.restTemplate.execute(resolvedUri, HttpMethod.DELETE, clientHttpRequest -> this.createRestCallback(clientHttpRequest, authentication), null);
        }
        catch (RestClientException restClientException) {
            RestClientExceptionHandlerEnvironment exceptionHandlerEnvironment = RestClientExceptionHandlerEnvironment.builder().restClientException(restClientException).requestURI(resource.getHref()).username(authentication.getName()).build();
            OwncloudRestUtils.handleRestClientException(exceptionHandlerEnvironment);
        }
    }

    private URI resolveAsFileURI(URI relativeTo, String username) {
        URI userRoot = this.getResolvedRootUri(username);
        if (relativeTo == null || StringUtils.isBlank((CharSequence)relativeTo.getPath())) {
            return userRoot;
        }
        return URI.create(UriComponentsBuilder.fromUri((URI)userRoot).path(relativeTo.getPath()).toUriString()).normalize();
    }

    private void createRestCallback(ClientHttpRequest clientHttpRequest, Authentication authentication) throws IOException {
        OwncloudRestUtils.addAuthorizationHeader(clientHttpRequest.getHeaders(), authentication);
    }

    @Override
    public InputStream getInputStream(OwncloudFileResource resource) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        PipedInputStreamRestSynchronizer pipedInputStreamSynchronizer = PipedInputStreamRestSynchronizer.build().authentication(authentication).owncloudRestProperties(this.properties).restOperations((RestOperations)this.restTemplate).uri(resource.getHref()).uriResolver(this::resolveAsFileURI).build();
        return pipedInputStreamSynchronizer.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(OwncloudFileResource resource) {
        this.checkOwncloudFileResource(resource);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        PipedOutputStreamRestSynchronizer pipedOutputStreamSynchronizer = PipedOutputStreamRestSynchronizer.builder().authentication(authentication).mediaType(resource.getMediaType()).owncloudRestProperties(this.properties).restOperations((RestOperations)this.restTemplate).uri(resource.getHref()).uriResolver(this::resolveAsFileURI).build();
        return pipedOutputStreamSynchronizer.getOutputStream();
    }

    private void checkOwncloudFileResource(OwncloudFileResource resource) {
        Validate.notNull((Object)resource);
        Validate.notNull((Object)resource.getHref());
        Validate.notNull((Object)resource.getMediaType());
        if (OwncloudUtils.isDirectory(resource)) {
            throw new OwncloudNoFileResourceException(resource.getHref());
        }
    }

    @Override
    public OutputStream getOutputStream(URI path, MediaType mediaType) {
        Optional<OwncloudResource> optionalExistingFile = this.find(path);
        if (optionalExistingFile.isPresent()) {
            OwncloudFileResource existingFile = optionalExistingFile.filter(OwncloudUtils::isNotDirectory).map(OwncloudUtils::toOwncloudFileResource).orElseThrow(() -> new OwncloudNoFileResourceException(path));
            return this.getOutputStream(existingFile);
        }
        OwncloudRestFileResourceImpl resource = OwncloudRestFileResourceImpl.fileBuilder().owncloudResource(OwncloudRestResourceImpl.builder().href(path).mediaType(mediaType).build()).build();
        return this.getOutputStream(resource);
    }

    @Override
    public OwncloudQuota getQuota() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.userService.getQuota(authentication.getName());
    }

    private static class SardineExceptionHandlerEnvironment {
        private final URI uri;
        private final SardineException sardineException;
        private final Map<Integer, Function<SardineExceptionHandlerEnvironment, Optional<OwncloudResource>>> statusCodeHandler = new HashMap<Integer, Function<SardineExceptionHandlerEnvironment, Optional<OwncloudResource>>>();

        private SardineExceptionHandlerEnvironment(URI uri, SardineException sardineException) {
            Validate.notNull((Object)uri);
            Validate.notNull((Object)sardineException);
            this.uri = uri;
            this.sardineException = sardineException;
            this.registerHandler(404, this::handleStatusCodeNotFound);
        }

        void registerHandler(int statusCode, Function<SardineExceptionHandlerEnvironment, Optional<OwncloudResource>> statusCodeHandler) {
            this.statusCodeHandler.put(statusCode, statusCodeHandler);
        }

        private Optional<OwncloudResource> handleStatusCodeNotFound(SardineExceptionHandlerEnvironment environment) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            throw new OwncloudResourceNotFoundException(environment.getUri(), authentication.getName());
        }

        Function<SardineExceptionHandlerEnvironment, Optional<OwncloudResource>> getHandlerFor(int statusCode) {
            return this.statusCodeHandler.get(statusCode);
        }

        public static SardineExceptionHandlerEnvironmentBuilder builder() {
            return new SardineExceptionHandlerEnvironmentBuilder();
        }

        public URI getUri() {
            return this.uri;
        }

        public SardineException getSardineException() {
            return this.sardineException;
        }

        public static class SardineExceptionHandlerEnvironmentBuilder {
            private URI uri;
            private SardineException sardineException;

            SardineExceptionHandlerEnvironmentBuilder() {
            }

            public SardineExceptionHandlerEnvironmentBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            public SardineExceptionHandlerEnvironmentBuilder sardineException(SardineException sardineException) {
                this.sardineException = sardineException;
                return this;
            }

            public SardineExceptionHandlerEnvironment build() {
                return new SardineExceptionHandlerEnvironment(this.uri, this.sardineException);
            }

            public String toString() {
                return "OwncloudRestResourceServiceImpl.SardineExceptionHandlerEnvironment.SardineExceptionHandlerEnvironmentBuilder(uri=" + this.uri + ", sardineException=" + this.sardineException + ")";
            }
        }
    }

    private static class OwncloudResourceConversionProperties {
        private final URI rootPath;
        private URI searchPath;
        private String renamedSearchPath;

        OwncloudResourceConversionProperties(URI rootPath, URI searchPath, String renamedSearchPath) {
            this.rootPath = rootPath;
            this.searchPath = searchPath;
            this.renamedSearchPath = renamedSearchPath;
        }

        public static OwncloudResourceConversionPropertiesBuilder builder() {
            return new OwncloudResourceConversionPropertiesBuilder();
        }

        public URI getRootPath() {
            return this.rootPath;
        }

        public URI getSearchPath() {
            return this.searchPath;
        }

        public String getRenamedSearchPath() {
            return this.renamedSearchPath;
        }

        public void setSearchPath(URI searchPath) {
            this.searchPath = searchPath;
        }

        public void setRenamedSearchPath(String renamedSearchPath) {
            this.renamedSearchPath = renamedSearchPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwncloudResourceConversionProperties)) {
                return false;
            }
            OwncloudResourceConversionProperties other = (OwncloudResourceConversionProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$rootPath = this.getRootPath();
            URI other$rootPath = other.getRootPath();
            if (this$rootPath == null ? other$rootPath != null : !((Object)this$rootPath).equals(other$rootPath)) {
                return false;
            }
            URI this$searchPath = this.getSearchPath();
            URI other$searchPath = other.getSearchPath();
            if (this$searchPath == null ? other$searchPath != null : !((Object)this$searchPath).equals(other$searchPath)) {
                return false;
            }
            String this$renamedSearchPath = this.getRenamedSearchPath();
            String other$renamedSearchPath = other.getRenamedSearchPath();
            return !(this$renamedSearchPath == null ? other$renamedSearchPath != null : !this$renamedSearchPath.equals(other$renamedSearchPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OwncloudResourceConversionProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $rootPath = this.getRootPath();
            result = result * 59 + ($rootPath == null ? 43 : ((Object)$rootPath).hashCode());
            URI $searchPath = this.getSearchPath();
            result = result * 59 + ($searchPath == null ? 43 : ((Object)$searchPath).hashCode());
            String $renamedSearchPath = this.getRenamedSearchPath();
            result = result * 59 + ($renamedSearchPath == null ? 43 : $renamedSearchPath.hashCode());
            return result;
        }

        public String toString() {
            return "OwncloudRestResourceServiceImpl.OwncloudResourceConversionProperties(rootPath=" + this.getRootPath() + ", searchPath=" + this.getSearchPath() + ", renamedSearchPath=" + this.getRenamedSearchPath() + ")";
        }

        public static class OwncloudResourceConversionPropertiesBuilder {
            private URI rootPath;
            private URI searchPath;
            private String renamedSearchPath;

            OwncloudResourceConversionPropertiesBuilder() {
            }

            public OwncloudResourceConversionPropertiesBuilder rootPath(URI rootPath) {
                this.rootPath = rootPath;
                return this;
            }

            public OwncloudResourceConversionPropertiesBuilder searchPath(URI searchPath) {
                this.searchPath = searchPath;
                return this;
            }

            public OwncloudResourceConversionPropertiesBuilder renamedSearchPath(String renamedSearchPath) {
                this.renamedSearchPath = renamedSearchPath;
                return this;
            }

            public OwncloudResourceConversionProperties build() {
                return new OwncloudResourceConversionProperties(this.rootPath, this.searchPath, this.renamedSearchPath);
            }

            public String toString() {
                return "OwncloudRestResourceServiceImpl.OwncloudResourceConversionProperties.OwncloudResourceConversionPropertiesBuilder(rootPath=" + this.rootPath + ", searchPath=" + this.searchPath + ", renamedSearchPath=" + this.renamedSearchPath + ")";
            }
        }
    }
}

