/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractOwncloudRestServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserDetailsService;

public class OwncloudRestUserDetailsServiceImpl
extends AbstractOwncloudRestServiceImpl
implements OwncloudRestUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestUserDetailsServiceImpl.class);

    OwncloudRestUserDetailsServiceImpl(RestTemplateBuilder builder, OwncloudRestProperties properties) {
        super(builder, properties);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Validate.notBlank((CharSequence)username);
        log.debug("Get Information about User {} from the Location {}", (Object)username, (Object)this.getLocation());
        Ocs.User user = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(), Ocs.User.class, username);
        return this.loadPreloadedUserByUsername(username, user);
    }

    @Override
    public OwncloudUserDetails loadPreloadedUserByUsername(String username, Ocs.User preloadedUser) throws UsernameNotFoundException {
        log.debug("Get Information about the Group Memberships of User {} from the Location {}", (Object)username, (Object)this.getLocation());
        Ocs.Groups groups = this.exchange("/cloud/users/{user}/groups", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, username);
        return this.convert(username, preloadedUser, groups);
    }
}

