/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudGroupNotFoundException;
import software.coolstuff.springframework.owncloud.exception.auth.OwncloudUsernameAlreadyExistsException;
import software.coolstuff.springframework.owncloud.model.OwncloudModificationUser;
import software.coolstuff.springframework.owncloud.model.OwncloudUserDetails;
import software.coolstuff.springframework.owncloud.service.impl.CheckOwncloudModification;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractOwncloudRestServiceImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestQuotaImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUserServiceExtension;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;

public class OwncloudRestUserServiceImpl
extends AbstractOwncloudRestServiceImpl
implements OwncloudRestUserServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestUserServiceImpl.class);

    OwncloudRestUserServiceImpl(RestTemplateBuilder builder, OwncloudRestProperties properties) {
        super(builder, properties);
    }

    @Override
    public Optional<OwncloudUserDetails> findOne(String username) {
        try {
            return Optional.of(this.findOneWithExceptionWhenNotFound(username));
        }
        catch (UsernameNotFoundException ignored) {
            return Optional.empty();
        }
    }

    private OwncloudUserDetails findOneWithExceptionWhenNotFound(String username) {
        Validate.notBlank((CharSequence)username);
        log.debug("Get Information about User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.User user = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(), Ocs.User.class, username);
        log.debug("Get all Groups assigned to User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.Groups groups = this.exchange("/cloud/users/{user}/groups", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, username);
        return this.convert(username, user, groups);
    }

    @Override
    public List<String> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<String> findAll(String filter) {
        Ocs.Users users = null;
        if (StringUtils.isBlank((CharSequence)filter)) {
            log.debug("Get all Users by Filter Criteria {} from Location {}", (Object)filter, (Object)this.getLocation());
            users = this.exchange("/cloud/users", HttpMethod.GET, this.emptyEntity(), Ocs.Users.class, new Object[0]);
        } else {
            log.debug("Get all Users from Location {}", (Object)this.getLocation());
            users = this.exchange("/cloud/users?search={filter}", HttpMethod.GET, this.emptyEntity(), Ocs.Users.class, filter);
        }
        return this.convertUsers(users);
    }

    private List<String> convertUsers(Ocs.Users ocsUsers) {
        ArrayList<String> users = new ArrayList<String>();
        if (this.isUsersNotNull(ocsUsers)) {
            for (Ocs.Users.Data.Element element : ocsUsers.getData().getUsers()) {
                log.trace("Add User {} to the Result List", (Object)element.getElement());
                users.add(element.getElement());
            }
        }
        return users;
    }

    private boolean isUsersNotNull(Ocs.Users ocsUsers) {
        return ocsUsers != null && ocsUsers.getData() != null && ocsUsers.getData().getUsers() != null;
    }

    @Override
    public OwncloudRestQuotaImpl getQuota(String username) {
        log.debug("Get Information about User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.User user = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(), Ocs.User.class, username);
        Ocs.User.Data.Quota quota = user.getData().getQuota();
        return OwncloudRestQuotaImpl.builder().username(username).free(quota.getFree()).used(quota.getUsed()).total(quota.getTotal()).relative(quota.getRelative().floatValue()).build();
    }

    @Override
    @CheckOwncloudModification
    public OwncloudUserDetails save(OwncloudModificationUser user) {
        Validate.notNull((Object)user);
        Validate.notBlank((CharSequence)user.getUsername());
        try {
            log.debug("Check, if the User {} exists at Location {}", (Object)user.getUsername(), (Object)this.getLocation());
            Ocs.User existingUser = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(), Ocs.User.class, user.getUsername());
            this.updateUser(user, existingUser.getData());
        }
        catch (UsernameNotFoundException e) {
            this.createUser(user);
        }
        return this.findOneWithExceptionWhenNotFound(user.getUsername());
    }

    private void updateUser(OwncloudModificationUser user, Ocs.User.Data existingUser) {
        if (this.isDisplaynameChanged(user, existingUser)) {
            this.updateOwncloudUserField(user.getUsername(), UserUpdateField.DISPLAY_NAME, user.getDisplayname());
        }
        if (this.isEmailChanged(user, existingUser)) {
            this.updateOwncloudUserField(user.getUsername(), UserUpdateField.EMAIL, user.getEmail());
        }
        if (this.isQuotaChanged(user, existingUser)) {
            this.updateOwncloudUserField(user.getUsername(), UserUpdateField.QUOTA, user.getQuota());
        }
        if (user.isEnabled() != existingUser.isEnabled()) {
            this.changeOwncloudUserAvailabilityStatus(user.getUsername(), user.isEnabled());
        }
        this.manageGroupMemberships(user.getUsername(), user.getGroups());
    }

    private boolean isDisplaynameChanged(OwncloudModificationUser user, Ocs.User.Data existingUser) {
        return !StringUtils.equals((CharSequence)user.getDisplayname(), (CharSequence)existingUser.getDisplayname());
    }

    private void updateOwncloudUserField(String username, UserUpdateField updateField, Object value) {
        log.trace("Create the Message Body for the Change Request of the Attribute {} of User {} on Location {}", new Object[]{updateField, username, this.getLocation()});
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("key", Lists.newArrayList((Object[])new String[]{updateField.getFieldName()}));
        if (value != null) {
            data.put("value", Lists.newArrayList((Object[])new String[]{updateField.format(value)}));
        }
        log.debug("Update Attribute {} of User {} on Location {}", new Object[]{updateField, username, this.getLocation()});
        this.exchange("/cloud/users/{user}", HttpMethod.PUT, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkFieldUpdate(authenticatedUser, uri, meta, username), username);
    }

    private void checkFieldUpdate(String authenticatedUser, String uri, Ocs.Meta meta, String username) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.warn("Error 101: User {} not found", (Object)username);
                throw new IllegalStateException("User " + username + " not found");
            }
            case 102: {
                log.error("Error 102: {}", (Object)meta.getMessage());
                throw new IllegalStateException(meta.getMessage());
            }
            case 103: {
                log.error("Error 103: {}", (Object)meta.getMessage());
                throw new IllegalStateException(meta.getMessage());
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    private boolean isEmailChanged(OwncloudModificationUser user, Ocs.User.Data existingUser) {
        return !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)existingUser.getEmail());
    }

    private boolean isQuotaChanged(OwncloudModificationUser user, Ocs.User.Data existingUser) {
        Long newQuota = user.getQuota();
        Long existingQuota = existingUser.getQuota() != null ? existingUser.getQuota().getTotal() : null;
        return ObjectUtils.compare((Comparable)newQuota, (Comparable)existingQuota) != 0;
    }

    private void changeOwncloudUserAvailabilityStatus(String username, boolean status) {
        log.debug("{} User {} on Location {}", new Object[]{status ? "Enable" : "Disable", username, this.getLocation()});
        this.exchange("/cloud/users/{user}/{status}", HttpMethod.PUT, this.emptyEntity(), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkAvailabilityStatusUpdate(authenticatedUser, uri, meta, username), username, status ? "enable" : "disable");
    }

    private void checkAvailabilityStatusUpdate(String authenticatedUser, String uri, Ocs.Meta meta, String username) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: User {} not found", (Object)username);
                throw new IllegalStateException("User " + username + " not found");
            }
            case 102: {
                log.error("Error 102: {}", (Object)meta.getMessage());
                throw new IllegalStateException(meta.getMessage());
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", username, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    private void manageGroupMemberships(String username, List<String> expectedGroups) {
        HashMap<String, List<String>> data;
        log.debug("Get the existing Group Memberships of User {} from Location {}", (Object)username, (Object)this.getLocation());
        Ocs.Groups ocsGroups = this.exchange("/cloud/users/{user}/groups", HttpMethod.GET, this.emptyEntity(), Ocs.Groups.class, username);
        List<String> actualGroups = OwncloudRestUtils.convertGroups(ocsGroups);
        if (CollectionUtils.isNotEmpty(expectedGroups)) {
            for (String groupname : expectedGroups) {
                if (actualGroups.contains(groupname)) {
                    log.trace("Group {} is already assigned to User {}", (Object)groupname, (Object)username);
                    actualGroups.remove(groupname);
                    continue;
                }
                log.trace("Create Message Body for assign Group {} to User {}", (Object)groupname, (Object)username);
                data = new HashMap();
                data.put("groupid", Lists.newArrayList((Object[])new String[]{groupname}));
                log.debug("Assign Group {} to User {} on Location {}", new Object[]{groupname, username, this.getLocation()});
                this.exchange("/cloud/users/{user}/groups", HttpMethod.POST, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkAssignGroupMembership(authenticatedUser, uri, meta, username, groupname), username);
            }
        }
        if (CollectionUtils.isNotEmpty(actualGroups)) {
            for (String groupname : actualGroups) {
                log.trace("Create Message Body for unassign Group {} from User {}", (Object)groupname, (Object)username);
                data = new HashMap<String, List<String>>();
                data.put("groupid", Lists.newArrayList((Object[])new String[]{groupname}));
                log.debug("Remove Group {} from User {} on Location {}", new Object[]{groupname, username, this.getLocation()});
                this.exchange("/cloud/users/{user}/groups", HttpMethod.DELETE, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkRemoveGroupMembership(authenticatedUser, uri, meta, username, groupname), username);
            }
        }
    }

    private void checkAssignGroupMembership(String authenticatedUser, String uri, Ocs.Meta meta, String username, String groupname) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: {}", (Object)meta.getMessage());
                throw new IllegalArgumentException(meta.getMessage());
            }
            case 102: {
                log.warn("Error 102: Owncloud Group {} not found", (Object)groupname);
                throw new OwncloudGroupNotFoundException(groupname);
            }
            case 103: {
                log.warn("Error 103: User {} not found", (Object)username);
                throw new IllegalStateException("User " + username + " not found");
            }
            case 104: {
                String exceptionMessage = String.format("User %s is not authorized to assign Group %s to User %s", username, groupname, username);
                log.warn("Error 104: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
            case 105: {
                String exceptionMessage = String.format("Error while assign Group %s to User %s. Reason: %s", groupname, username, StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
                log.error("Error 105: {}", (Object)exceptionMessage);
                throw new IllegalStateException(exceptionMessage);
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", username, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    private void checkRemoveGroupMembership(String authenticatedUser, String uri, Ocs.Meta meta, String username, String groupname) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: {}", (Object)meta.getMessage());
                throw new IllegalArgumentException(meta.getMessage());
            }
            case 102: {
                log.warn("Error 102: Owncloud Group {} not found", (Object)groupname);
                throw new OwncloudGroupNotFoundException(groupname);
            }
            case 103: {
                log.warn("Error 103: User {} not found", (Object)username);
                throw new IllegalStateException("User " + username + " not found");
            }
            case 104: {
                String exceptionMessage = String.format("User %s is not authorized to unassign Group %s from User %s", authenticatedUser, groupname, username);
                log.warn("Error 104: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
            case 105: {
                String exceptionMessage = String.format("Error while unassign Group %s from User %s. Reason: %s", groupname, username, StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
                log.error("Error 105: {}", (Object)exceptionMessage);
                throw new IllegalStateException(exceptionMessage);
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    private void createUser(OwncloudModificationUser user) {
        Validate.notBlank((CharSequence)user.getPassword());
        log.trace("Create the Message Body for the Creation Request of User {}", (Object)user.getUsername());
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("userid", Lists.newArrayList((Object[])new String[]{user.getUsername()}));
        data.put("password", Lists.newArrayList((Object[])new String[]{user.getPassword()}));
        log.debug("Create User {}", (Object)user.getUsername());
        this.exchange("/cloud/users", HttpMethod.POST, this.multiValuedEntity(data), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkCreateUser(authenticatedUser, uri, meta, user.getUsername()), new Object[0]);
        log.info("User {} successfully created", (Object)user.getUsername());
        log.debug("Re-Read the Information about User {} from Location {}", (Object)user.getUsername(), (Object)this.getLocation());
        Ocs.User existingUser = this.exchange("/cloud/users/{user}", HttpMethod.GET, this.emptyEntity(), Ocs.User.class, user.getUsername());
        this.updateUser(user, existingUser.getData());
    }

    private void checkCreateUser(String authenticatedUser, String uri, Ocs.Meta meta, String username) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: {}", (Object)meta.getMessage());
                throw new IllegalArgumentException(meta.getMessage());
            }
            case 102: {
                log.warn("Error 102: User {} already exists", (Object)username);
                throw new OwncloudUsernameAlreadyExistsException(username);
            }
            case 103: {
                log.error("Error 103: {}", (Object)meta.getMessage());
                throw new IllegalStateException(meta.getMessage());
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    @Override
    @CheckOwncloudModification
    public void delete(String username) {
        Validate.notBlank((CharSequence)username);
        log.debug("Delete User {} from Location {}", (Object)username, (Object)this.getLocation());
        this.exchange("/cloud/users/{user}", HttpMethod.DELETE, this.emptyEntity(), Ocs.Void.class, (String authenticatedUser, String uri, Ocs.Meta meta) -> this.checkDeleteUser(authenticatedUser, uri, meta, username), username);
        log.info("User {} successfully removed from Location {}", (Object)username, (Object)this.getLocation());
    }

    private void checkDeleteUser(String authenticatedUser, String uri, Ocs.Meta meta, String username) {
        if ("ok".equals(meta.getStatus())) {
            return;
        }
        switch (meta.getStatuscode()) {
            case 101: {
                log.error("Error 101: User {} not found", (Object)username);
                throw new UsernameNotFoundException(username);
            }
            case 997: {
                String exceptionMessage = String.format("User %s is not authorized to access Resource %s", authenticatedUser, uri);
                log.warn("Error 997: {}", (Object)exceptionMessage);
                throw new AccessDeniedException(exceptionMessage);
            }
        }
        String exceptionMessage = String.format("Unknown Error Code %d. Reason: %s", meta.getStatuscode(), StringUtils.defaultIfEmpty((CharSequence)meta.getMessage(), (CharSequence)""));
        log.error(exceptionMessage);
        throw new IllegalStateException(exceptionMessage);
    }

    private static enum UserUpdateField {
        DISPLAY_NAME("display"),
        EMAIL("email"),
        PASSWORD("password"),
        QUOTA("quota", new DecimalFormat("###########0"));

        private final String fieldName;
        private Format format;

        private UserUpdateField(String fieldName) {
            this.fieldName = fieldName;
        }

        private UserUpdateField(String fieldName, Format format) {
            this(fieldName);
            this.format = format;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String format(Object value) {
            if (this.format == null) {
                return value != null ? value.toString() : null;
            }
            return this.format.format(value);
        }
    }
}

