/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.HttpStatusCodeException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudQuotaExceededException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudResourceNotFoundException;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudRestResourceException;
import software.coolstuff.springframework.owncloud.service.impl.rest.Ocs;
import software.coolstuff.springframework.owncloud.service.impl.rest.RestClientExceptionHandlerEnvironment;

final class OwncloudRestUtils {
    private static final Logger log = LoggerFactory.getLogger(OwncloudRestUtils.class);

    public static List<String> convertGroups(Ocs.Groups ocsGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        if (OwncloudRestUtils.isGroupsNotNull(ocsGroups)) {
            for (Ocs.Groups.Data.Group group : ocsGroups.getData().getGroups()) {
                groups.add(group.getGroup());
            }
        }
        return groups;
    }

    private static boolean isGroupsNotNull(Ocs.Groups ocsGroups) {
        return ocsGroups != null && ocsGroups.getData() != null && ocsGroups.getData().getGroups() != null;
    }

    public static URL checkAndConvertLocation(String location) throws MalformedURLException {
        Validate.notBlank((CharSequence)location);
        log.debug("Check if the Location {} is a valid URL", (Object)location);
        URL url = new URL(location);
        log.debug("Check if the Location {} either start with http or https", (Object)location);
        if (OwncloudRestUtils.isNotValidProtocol(url)) {
            String exceptionMessage = "Invalid Protocol " + url.getProtocol() + ". Only http or https are allowed";
            log.error(exceptionMessage);
            throw new IllegalArgumentException(exceptionMessage);
        }
        return url;
    }

    private static boolean isNotValidProtocol(URL url) {
        return !StringUtils.equals((CharSequence)url.getProtocol(), (CharSequence)"http") && !StringUtils.equals((CharSequence)url.getProtocol(), (CharSequence)"https");
    }

    public static String appendDefaultPath(URL locationURL, String defaultPath) {
        log.debug("Extract the Root-URI from URL {}", (Object)locationURL);
        if (StringUtils.isBlank((CharSequence)locationURL.getPath()) || "/".equals(locationURL.getPath())) {
            return URI.create(locationURL.toString() + defaultPath).toString();
        }
        return locationURL.toString();
    }

    public static HttpHeaders addAuthorizationHeader(Authentication authentication) {
        HttpHeaders headers = new HttpHeaders();
        OwncloudRestUtils.addAuthorizationHeader(headers, authentication);
        return headers;
    }

    public static void addAuthorizationHeader(HttpHeaders headers, Authentication authentication) {
        headers.add("Authorization", OwncloudRestUtils.encodeCredentialsForBasicAuthorization(authentication));
    }

    public static String encodeCredentialsForBasicAuthorization(Authentication authentication) {
        Validate.notNull((Object)authentication);
        if (authentication.getCredentials() != null) {
            return OwncloudRestUtils.encodeCredentialsForBasicAuthorization(authentication.getName(), authentication.getCredentials());
        }
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        return OwncloudRestUtils.encodeCredentialsForBasicAuthorization(userDetails.getUsername(), userDetails.getPassword());
    }

    public static String encodeCredentialsForBasicAuthorization(String username, Object password) {
        Validate.notBlank((CharSequence)username);
        Validate.notNull((Object)password);
        Validate.isTrue((boolean)ClassUtils.isAssignable(CharSequence.class, password.getClass()));
        Validate.notBlank((CharSequence)((CharSequence)password));
        Base64.Encoder base64Encoder = Base64.getEncoder();
        String encodedCredentials = base64Encoder.encodeToString((username + ':' + password).getBytes());
        log.trace("Use Basic Authorization with User {}", (Object)username);
        return "Basic " + encodedCredentials;
    }

    public static void handleRestClientException(RestClientExceptionHandlerEnvironment environment) {
        if (environment.getRestClientException() == null) {
            return;
        }
        if (ClassUtils.isAssignable(HttpStatusCodeException.class, ((Object)((Object)environment.getRestClientException())).getClass())) {
            OwncloudRestUtils.handleHttpStatusCodeException(environment);
        }
        throw new OwncloudRestResourceException(environment.getRestClientException());
    }

    private static void handleHttpStatusCodeException(RestClientExceptionHandlerEnvironment environment) {
        HttpStatusCodeException httpStatusCodeException = (HttpStatusCodeException)environment.getRestClientException();
        switch (httpStatusCodeException.getStatusCode()) {
            case NOT_FOUND: {
                throw new OwncloudResourceNotFoundException(environment.getRequestURI(), environment.getUsername());
            }
            case INSUFFICIENT_STORAGE: {
                throw new OwncloudQuotaExceededException(environment.getRequestURI(), environment.getUsername());
            }
        }
    }

    private OwncloudRestUtils() {
    }
}

