/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudRestResourceException;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractPipedStreamRestSynchronizerImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.PipedInputStreamRestSynchronizer;
import software.coolstuff.springframework.owncloud.service.impl.rest.RestClientExceptionHandlerEnvironment;

class PipedInputStreamRestSynchronizerImpl
extends AbstractPipedStreamRestSynchronizerImpl
implements PipedInputStreamRestSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(PipedInputStreamRestSynchronizerImpl.class);
    private final SynchronizedPipedInputStream pipedInputStream = new SynchronizedPipedInputStream();

    private PipedInputStreamRestSynchronizerImpl(Authentication authentication, URI uri, OwncloudRestProperties owncloudRestProperties, RestOperations restOperations, BiFunction<URI, String, URI> uriResolver) {
        super(authentication, uri, owncloudRestProperties, restOperations, uriResolver);
    }

    private static PipedInputStreamRestSynchronizer build(Authentication authentication, URI uri, OwncloudRestProperties owncloudRestProperties, RestOperations restOperations, BiFunction<URI, String, URI> uriResolver) {
        return new PipedInputStreamRestSynchronizerImpl(authentication, uri, owncloudRestProperties, restOperations, uriResolver);
    }

    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.GET;
    }

    @Override
    protected void createPipedStream() {
        try (PipedOutputStream output = new PipedOutputStream(this.pipedInputStream);){
            this.setPipeReady();
            AbstractPipedStreamRestSynchronizerImpl.ExecutionEnvironment executionEnvironment = AbstractPipedStreamRestSynchronizerImpl.ExecutionEnvironment.builder().responseExtractor(response -> this.copy(response.getBody(), output)).runtimeExceptionHandler(this.pipedInputStream::setRuntimeException).build();
            this.execute(executionEnvironment);
        }
        catch (IOException e) {
            throw new OwncloudRestResourceException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        this.startThreadAndWaitForConnectedPipe();
        return this.pipedInputStream;
    }

    public static PipedInputStreamRestSynchronizerBuilder builder() {
        return new PipedInputStreamRestSynchronizerBuilder();
    }

    public static class PipedInputStreamRestSynchronizerBuilder {
        private Authentication authentication;
        private URI uri;
        private OwncloudRestProperties owncloudRestProperties;
        private RestOperations restOperations;
        private BiFunction<URI, String, URI> uriResolver;

        PipedInputStreamRestSynchronizerBuilder() {
        }

        public PipedInputStreamRestSynchronizerBuilder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public PipedInputStreamRestSynchronizerBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public PipedInputStreamRestSynchronizerBuilder owncloudRestProperties(OwncloudRestProperties owncloudRestProperties) {
            this.owncloudRestProperties = owncloudRestProperties;
            return this;
        }

        public PipedInputStreamRestSynchronizerBuilder restOperations(RestOperations restOperations) {
            this.restOperations = restOperations;
            return this;
        }

        public PipedInputStreamRestSynchronizerBuilder uriResolver(BiFunction<URI, String, URI> uriResolver) {
            this.uriResolver = uriResolver;
            return this;
        }

        public PipedInputStreamRestSynchronizer build() {
            return PipedInputStreamRestSynchronizerImpl.build(this.authentication, this.uri, this.owncloudRestProperties, this.restOperations, this.uriResolver);
        }

        public String toString() {
            return "PipedInputStreamRestSynchronizerImpl.PipedInputStreamRestSynchronizerBuilder(authentication=" + this.authentication + ", uri=" + this.uri + ", owncloudRestProperties=" + this.owncloudRestProperties + ", restOperations=" + this.restOperations + ", uriResolver=" + this.uriResolver + ")";
        }
    }

    private class SynchronizedPipedInputStream
    extends PipedInputStream {
        private Optional<RuntimeException> runtimeException = Optional.empty();
        private boolean alreadyClosed = false;

        private SynchronizedPipedInputStream() {
        }

        public void setRuntimeException(RuntimeException runtimeException) {
            this.runtimeException = Optional.ofNullable(runtimeException);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.alreadyClosed) {
                log.warn("InputStream has already been marked as closed");
                return;
            }
            try {
                super.close();
            }
            finally {
                this.alreadyClosed = true;
            }
            this.runtimeException.ifPresent(this::handleRuntimeException);
        }

        private void handleRuntimeException(RuntimeException exception) {
            if (exception instanceof RestClientException) {
                this.handleRestClientException((RestClientException)((Object)exception));
            }
            throw exception;
        }

        private void handleRestClientException(RestClientException exception) {
            RestClientExceptionHandlerEnvironment exceptionHandlerEnvironment = RestClientExceptionHandlerEnvironment.builder().restClientException(exception).requestURI(PipedInputStreamRestSynchronizerImpl.this.getUri()).username(PipedInputStreamRestSynchronizerImpl.this.getUsername()).build();
            OwncloudRestUtils.handleRestClientException(exceptionHandlerEnvironment);
        }
    }
}

