/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import software.coolstuff.springframework.owncloud.exception.resource.OwncloudRestResourceException;
import software.coolstuff.springframework.owncloud.service.impl.rest.AbstractPipedStreamRestSynchronizerImpl;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestProperties;
import software.coolstuff.springframework.owncloud.service.impl.rest.OwncloudRestUtils;
import software.coolstuff.springframework.owncloud.service.impl.rest.PipedOutputStreamRestSynchronizer;
import software.coolstuff.springframework.owncloud.service.impl.rest.RestClientExceptionHandlerEnvironment;

class PipedOutputStreamRestSynchronizerImpl
extends AbstractPipedStreamRestSynchronizerImpl
implements PipedOutputStreamRestSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(PipedOutputStreamRestSynchronizerImpl.class);
    private final Optional<MediaType> mediaType;
    private final SynchronizedPipedOutputStream pipedOutputStream = new SynchronizedPipedOutputStream();

    private PipedOutputStreamRestSynchronizerImpl(Authentication authentication, URI uri, MediaType mediaType, OwncloudRestProperties owncloudRestProperties, RestOperations restOperations, BiFunction<URI, String, URI> uriResolver) {
        super(authentication, uri, owncloudRestProperties, restOperations, uriResolver);
        this.mediaType = Optional.ofNullable(mediaType);
    }

    private static PipedOutputStreamRestSynchronizer build(Authentication authentication, URI uri, MediaType mediaType, OwncloudRestProperties owncloudRestProperties, RestOperations restOperations, BiFunction<URI, String, URI> uriResolver) {
        return new PipedOutputStreamRestSynchronizerImpl(authentication, uri, mediaType, owncloudRestProperties, restOperations, uriResolver);
    }

    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.PUT;
    }

    @Override
    protected void createPipedStream() {
        try (PipedInputStream input = new PipedInputStream(this.pipedOutputStream);){
            this.setPipeReady();
            AbstractPipedStreamRestSynchronizerImpl.ExecutionEnvironment executionEnvironment = AbstractPipedStreamRestSynchronizerImpl.ExecutionEnvironment.builder().requestCallback(clientHttpRequest -> this.setMediaTypeAndCopy(input, clientHttpRequest)).runtimeExceptionHandler(this.pipedOutputStream::setRuntimeException).afterExecutionCallback(this::waitForPipeReady).build();
            this.execute(executionEnvironment);
        }
        catch (IOException e) {
            throw new OwncloudRestResourceException(e);
        }
    }

    private void setMediaTypeAndCopy(InputStream input, ClientHttpRequest clientHttpRequest) throws IOException {
        this.addContentTypeHeader(clientHttpRequest);
        this.copy(input, clientHttpRequest.getBody());
    }

    private void addContentTypeHeader(ClientHttpRequest clientHttpRequest) {
        this.mediaType.ifPresent(mediaType -> {
            log.debug("Set the ContentType Header to {}", (Object)mediaType.toString());
            HttpHeaders headers = clientHttpRequest.getHeaders();
            headers.add("Content-Type", mediaType.toString());
        });
    }

    @Override
    public OutputStream getOutputStream() {
        this.startThreadAndWaitForConnectedPipe();
        return this.pipedOutputStream;
    }

    public static PipedOutputStreamRestSynchronizerBuilder builder() {
        return new PipedOutputStreamRestSynchronizerBuilder();
    }

    public static class PipedOutputStreamRestSynchronizerBuilder {
        private Authentication authentication;
        private URI uri;
        private MediaType mediaType;
        private OwncloudRestProperties owncloudRestProperties;
        private RestOperations restOperations;
        private BiFunction<URI, String, URI> uriResolver;

        PipedOutputStreamRestSynchronizerBuilder() {
        }

        public PipedOutputStreamRestSynchronizerBuilder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public PipedOutputStreamRestSynchronizerBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public PipedOutputStreamRestSynchronizerBuilder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public PipedOutputStreamRestSynchronizerBuilder owncloudRestProperties(OwncloudRestProperties owncloudRestProperties) {
            this.owncloudRestProperties = owncloudRestProperties;
            return this;
        }

        public PipedOutputStreamRestSynchronizerBuilder restOperations(RestOperations restOperations) {
            this.restOperations = restOperations;
            return this;
        }

        public PipedOutputStreamRestSynchronizerBuilder uriResolver(BiFunction<URI, String, URI> uriResolver) {
            this.uriResolver = uriResolver;
            return this;
        }

        public PipedOutputStreamRestSynchronizer build() {
            return PipedOutputStreamRestSynchronizerImpl.build(this.authentication, this.uri, this.mediaType, this.owncloudRestProperties, this.restOperations, this.uriResolver);
        }

        public String toString() {
            return "PipedOutputStreamRestSynchronizerImpl.PipedOutputStreamRestSynchronizerBuilder(authentication=" + this.authentication + ", uri=" + this.uri + ", mediaType=" + this.mediaType + ", owncloudRestProperties=" + this.owncloudRestProperties + ", restOperations=" + this.restOperations + ", uriResolver=" + this.uriResolver + ")";
        }
    }

    private class SynchronizedPipedOutputStream
    extends PipedOutputStream {
        private Optional<RuntimeException> runtimeException = Optional.empty();
        private boolean alreadyClosed = false;

        private SynchronizedPipedOutputStream() {
        }

        public void setRuntimeException(RuntimeException runtimeException) {
            this.runtimeException = Optional.ofNullable(runtimeException);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.alreadyClosed) {
                log.warn("OutputStream has already been marked as closed");
                return;
            }
            try {
                super.close();
            }
            finally {
                this.alreadyClosed = true;
                PipedOutputStreamRestSynchronizerImpl.this.setPipeReady();
                this.runtimeException.ifPresent(this::handleRuntimeException);
            }
        }

        private void handleRuntimeException(RuntimeException exception) {
            if (exception instanceof RestClientException) {
                this.handleRestClientException((RestClientException)((Object)exception));
            }
            throw exception;
        }

        private void handleRestClientException(RestClientException exception) {
            RestClientExceptionHandlerEnvironment exceptionHandlerEnvironment = RestClientExceptionHandlerEnvironment.builder().restClientException(exception).requestURI(PipedOutputStreamRestSynchronizerImpl.this.getUri()).username(PipedOutputStreamRestSynchronizerImpl.this.getUsername()).build();
            OwncloudRestUtils.handleRestClientException(exceptionHandlerEnvironment);
        }
    }
}

