/*
 * Decompiled with CFR 0.152.
 */
package software.coolstuff.springframework.owncloud.service.impl.rest;

import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import com.google.common.cache.CacheLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SardineCacheLoader
extends CacheLoader<String, Sardine> {
    private static final Logger log = LoggerFactory.getLogger(SardineCacheLoader.class);

    public Sardine load(String username) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.checkUsername(username, authentication);
        return this.createSardineImplementation(authentication);
    }

    private void checkUsername(String username, Authentication authentication) {
        log.debug("Check if the Username {} equals to the Name of the Authentication {}", (Object)username, (Object)authentication.getName());
        if (!StringUtils.equals((CharSequence)username, (CharSequence)authentication.getName())) {
            String logMessage = String.format("requested Username %s does not equal to the Username of the SecurityContextHolder %s", username, authentication.getName());
            log.error(logMessage);
            throw new IllegalStateException(logMessage);
        }
    }

    private Sardine createSardineImplementation(Authentication authentication) {
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        String username = userDetails.getUsername();
        log.debug("Create Sardine Implementation based on the UserDetails Object of User {}", (Object)username);
        return new SardineImpl(username, userDetails.getPassword());
    }
}

