package com.etsy.sbt.checkstyle

import com.etsy.sbt.checkstyle.CheckstyleSeverityLevel.CheckstyleSeverityLevel
import com.puppycrawl.tools.checkstyle.api.{AuditEvent, AuditListener, SeverityLevel}

import scala.collection.mutable

class CheckstyleListener extends AuditListener {
  var infoCount = 0
  var warningCount = 0
  var errorCount = 0

  override def auditStarted(event: AuditEvent): Unit = ()
  override def auditFinished(event: AuditEvent): Unit = ()
  override def fileStarted(event: AuditEvent): Unit = ()
  override def fileFinished(event: AuditEvent): Unit = ()

  override def addError(event: AuditEvent): Unit = {
    event.getSeverityLevel match {
      case SeverityLevel.INFO => infoCount += 1
      case SeverityLevel.WARNING => warningCount += 1
      case SeverityLevel.ERROR => errorCount += 1
      case SeverityLevel.IGNORE => // ignore
    }
  }

  override def addException(event: AuditEvent, throwable: Throwable): Unit = ()

  def highestErrorLevel: CheckstyleSeverityLevel = {
    if (errorCount > 0) {
      CheckstyleSeverityLevel.Error
    } else if (warningCount > 0) {
      CheckstyleSeverityLevel.Warning
    } else if (infoCount > 0) {
      CheckstyleSeverityLevel.Info
    } else {
      CheckstyleSeverityLevel.Ignore
    }
  }

  def currentStatus: String = {
    if (errorCount == 0 && warningCount == 0 && infoCount == 0) {
      "No issues found."
    } else {
      val status = mutable.StringBuilder.newBuilder

      if (errorCount > 0) {
        status ++= errorCount.toString
        status ++= " errors found. "
      }

      if (warningCount > 0) {
        status ++= warningCount.toString
        status ++= " warnings found. "
      }

      if (infoCount > 0) {
        status ++= infoCount.toString
        status ++= " informational issues found. "
      }

      status.dropRight(1)

      status.toString()
    }
  }
}
