/*
 * Decompiled with CFR 0.152.
 */
package com.etsy.sbt.checkstyle;

import com.etsy.sbt.checkstyle.CheckstyleConfigLocation;
import com.etsy.sbt.checkstyle.CheckstyleListener;
import com.etsy.sbt.checkstyle.CheckstyleSeverityLevel$;
import com.etsy.sbt.checkstyle.CheckstyleXSLTSettings;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;
import sbt.io.RichFile$;
import sbt.package$;
import sbt.util.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Checkstyle$ {
    public static Checkstyle$ MODULE$;

    static {
        new Checkstyle$();
    }

    public void checkstyle(Seq<File> sourceFiles, CheckstyleConfigLocation configLocation, Seq<File> resources, File outputFile, Set<CheckstyleXSLTSettings> xsltTransformations, Enumeration.Value severityLevel, Logger log) {
        package$.MODULE$.IO().createDirectory(outputFile.getParentFile());
        Checker checker = new Checker();
        try {
            ClassLoader checkstyleClassLoader = Checker.class.getClassLoader();
            checker.setModuleClassLoader(checkstyleClassLoader);
            Configuration checkerConfig = this.oiConfig(configLocation, resources);
            checker.configure(checkerConfig);
            CheckstyleListener checkstyleListener = new CheckstyleListener();
            checker.addListener((AuditListener)checkstyleListener);
            XMLLogger fileListener = new XMLLogger((OutputStream)new FileOutputStream(outputFile), AutomaticBean.OutputStreamOptions.CLOSE);
            checker.addListener((AuditListener)fileListener);
            Seq javaSources = (Seq)sourceFiles.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Checkstyle$.$anonfun$checkstyle$1(x$1)));
            checker.process((List)JavaConverters$.MODULE$.seqAsJavaListConverter(javaSources).asJava());
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Checkstyle complete. ").append(checkstyleListener.currentStatus()).toString());
            if (xsltTransformations.nonEmpty()) {
                this.applyXSLT(outputFile, xsltTransformations);
            }
            Enumeration.Value value = severityLevel;
            Enumeration.Value value2 = CheckstyleSeverityLevel$.MODULE$.Ignore();
            if ((value == null ? value2 != null : !value.equals(value2)) && severityLevel.$less$eq((Object)checkstyleListener.highestErrorLevel())) {
                throw scala.sys.package$.MODULE$.error("Severity of checkstyle errors exceeds project limit");
            }
        }
        finally {
            checker.destroy();
        }
    }

    private Configuration oiConfig(CheckstyleConfigLocation configLocation, Seq<File> resources) {
        Properties properties = new Properties();
        InputSource configSource = new InputSource(configLocation.load(resources));
        return ConfigurationLoader.loadConfiguration((InputSource)configSource, (PropertyResolver)new PropertiesExpander(properties), (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.EXECUTE);
    }

    private void applyXSLT(File input, Set<CheckstyleXSLTSettings> transformations) {
        Processor processor = new Processor(false);
        XdmNode source = processor.newDocumentBuilder().build(input);
        transformations.foreach((Function1 & Serializable & scala.Serializable)transform -> {
            Checkstyle$.$anonfun$applyXSLT$1(processor, source, transform);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkstyle$1(File x$1) {
        String string = RichFile$.MODULE$.ext$extension(package$.MODULE$.fileToRichFile(x$1));
        String string2 = "java";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$applyXSLT$1(Processor processor$1, XdmNode source$1, CheckstyleXSLTSettings transform) {
        Serializer output = processor$1.newSerializer(transform.output());
        XsltCompiler compiler = processor$1.newXsltCompiler();
        XsltExecutable executor = compiler.compile((Source)new StreamSource(transform.xslt()));
        XsltTransformer transformer = executor.load();
        transformer.setInitialContextNode(source$1);
        transformer.setDestination((Destination)output);
        transformer.transform();
        transformer.close();
        output.close();
    }

    private Checkstyle$() {
        MODULE$ = this;
    }
}

